/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.virgilsecurity.crypto.VirgilBase64;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Scanner;
import javax.xml.bind.DatatypeConverter;

public class ConvertionUtils {
    private static Gson gson = null;
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public static synchronized Gson getGson() {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder();
            gson = builder.disableHtmlEscaping().create();
        }
        return gson;
    }

    public static byte[] toBytes(String string) {
        if (string == null) {
            return new byte[0];
        }
        return string.getBytes(UTF8_CHARSET);
    }

    public static String toString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        return new String(bytes, UTF8_CHARSET);
    }

    public static String toHex(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        return DatatypeConverter.printHexBinary((byte[])bytes);
    }

    public static String toBase64String(String value) {
        byte[] bytes = value.getBytes(UTF8_CHARSET);
        return VirgilBase64.encode(bytes);
    }

    public static byte[] toBase64Bytes(String value) {
        String str = VirgilBase64.encode(value.getBytes(UTF8_CHARSET));
        return ConvertionUtils.toBytes(str);
    }

    public static String toBase64String(byte[] bytes) {
        return VirgilBase64.encode(bytes);
    }

    public static String base64ToString(String value) {
        return ConvertionUtils.toString(VirgilBase64.decode(value));
    }

    public static byte[] base64ToBytes(String value) {
        return VirgilBase64.decode(value);
    }

    public static String base64ToString(byte[] bytes) {
        return ConvertionUtils.toString(VirgilBase64.decode(ConvertionUtils.toString(bytes)));
    }

    public static byte[] hexToBytes(String value) {
        return DatatypeConverter.parseHexBinary((String)value);
    }

    public static String toString(InputStream is) {
        try (Scanner s = new Scanner(is, "UTF-8");){
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }
}

