/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.requests;

import com.virgilsecurity.sdk.client.exceptions.VirgilCardServiceException;
import com.virgilsecurity.sdk.client.model.dto.SignedRequestMetaModel;
import com.virgilsecurity.sdk.client.model.dto.SignedRequestModel;
import com.virgilsecurity.sdk.client.utils.ConvertionUtils;
import com.virgilsecurity.sdk.client.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class SignedRequest {
    protected Map<String, String> signatures = new HashMap<String, String>();
    protected String snapshot;

    protected abstract void restoreRequest(String var1, Map<String, String> var2);

    protected abstract String takeSnapshot();

    public void appendSignature(String cardId, String signature) {
        if (StringUtils.isBlank(cardId)) {
            throw new IllegalArgumentException("Argument 'cardId' must not be blank");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Argument 'signature' must not be null");
        }
        this.signatures.put(cardId, signature);
    }

    public Map<String, String> getSignatures() {
        return Collections.unmodifiableMap(this.signatures);
    }

    public SignedRequestModel getRequestModel() {
        SignedRequestMetaModel meta = new SignedRequestMetaModel();
        meta.setSignatures(this.signatures);
        SignedRequestModel requestModel = new SignedRequestModel();
        requestModel.setContentSnapshot(this.getSnapshot());
        requestModel.setMeta(meta);
        return requestModel;
    }

    public String exportRequest() {
        SignedRequestModel requestModel = this.getRequestModel();
        String json = ConvertionUtils.getGson().toJson((Object)requestModel);
        return ConvertionUtils.toBase64String(json);
    }

    public static <T extends SignedRequest> T importRequest(String exportedRequest, Class<T> clazz) {
        String jsonModel = ConvertionUtils.base64ToString(exportedRequest);
        SignedRequestModel model = (SignedRequestModel)ConvertionUtils.getGson().fromJson(jsonModel, SignedRequestModel.class);
        SignedRequest request = null;
        try {
            request = (SignedRequest)clazz.newInstance();
            request.snapshot = model.getContentSnapshot();
            if (model.getMeta() != null && model.getMeta().getSignatures() != null) {
                request.signatures = model.getMeta().getSignatures();
                request.restoreRequest(model.getContentSnapshot(), model.getMeta().getSignatures());
            }
            return (T)request;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new VirgilCardServiceException(e);
        }
    }

    public String getSnapshot() {
        if (this.snapshot == null) {
            this.snapshot = this.takeSnapshot();
        }
        return this.snapshot;
    }
}

