/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client;

import com.virgilsecurity.sdk.client.utils.StringUtils;
import com.virgilsecurity.sdk.crypto.exception.VirgilException;
import com.virgilsecurity.sdk.crypto.exceptions.NullArgumentException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class VirgilClientContext {
    private String accessToken;
    private URL cardsServiceURL;
    private URL readOnlyCardsServiceURL;
    private URL identityServiceURL;

    public VirgilClientContext(String accessToken) {
        if (accessToken == null) {
            throw new NullArgumentException("accessToken");
        }
        this.accessToken = accessToken;
        try {
            this.cardsServiceURL = new URL("https://cards.virgilsecurity.com");
            this.readOnlyCardsServiceURL = new URL("https://cards-ro.virgilsecurity.com");
            this.identityServiceURL = new URL("https://identity.virgilsecurity.com");
        }
        catch (MalformedURLException e) {
            throw new VirgilException(e.getMessage());
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        if (accessToken == null) {
            throw new NullArgumentException("accessToken");
        }
        this.accessToken = accessToken;
    }

    public static boolean isValidURI(String uri) {
        if (StringUtils.isBlank(uri)) {
            return false;
        }
        try {
            URI theUri = URI.create(uri);
            return theUri.isAbsolute();
        }
        catch (Exception e) {
            return false;
        }
    }

    public URL getReadOnlyCardsServiceURL() {
        return this.readOnlyCardsServiceURL;
    }

    public void setReadOnlyCardsServiceURL(URL readOnlyCardsServiceURL) {
        this.readOnlyCardsServiceURL = readOnlyCardsServiceURL;
    }

    public URL getCardsServiceURL() {
        return this.cardsServiceURL;
    }

    public void setCardsServiceURL(URL cardsServiceURL) {
        this.cardsServiceURL = cardsServiceURL;
    }

    public URL getIdentityServiceURL() {
        return this.identityServiceURL;
    }

    public void setIdentityServiceURL(URL identityServiceURL) {
        this.identityServiceURL = identityServiceURL;
    }
}

