/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client;

import com.virgilsecurity.sdk.client.CardValidator;
import com.virgilsecurity.sdk.client.VirgilClientContext;
import com.virgilsecurity.sdk.client.exceptions.CardValidationException;
import com.virgilsecurity.sdk.client.exceptions.VirgilCardServiceException;
import com.virgilsecurity.sdk.client.exceptions.VirgilServiceException;
import com.virgilsecurity.sdk.client.model.Card;
import com.virgilsecurity.sdk.client.model.CardScope;
import com.virgilsecurity.sdk.client.model.dto.CreateCardModel;
import com.virgilsecurity.sdk.client.model.dto.ErrorResponse;
import com.virgilsecurity.sdk.client.model.dto.SearchCriteria;
import com.virgilsecurity.sdk.client.model.dto.SearchRequest;
import com.virgilsecurity.sdk.client.model.dto.SignedResponseModel;
import com.virgilsecurity.sdk.client.model.identity.Identity;
import com.virgilsecurity.sdk.client.model.identity.Token;
import com.virgilsecurity.sdk.client.requests.CreateCardRequest;
import com.virgilsecurity.sdk.client.requests.RevokeCardRequest;
import com.virgilsecurity.sdk.client.utils.ConvertionUtils;
import com.virgilsecurity.sdk.client.utils.StreamUtils;
import com.virgilsecurity.sdk.client.utils.StringUtils;
import com.virgilsecurity.sdk.crypto.exceptions.EmptyArgumentException;
import com.virgilsecurity.sdk.crypto.exceptions.NullArgumentException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VirgilClient {
    private VirgilClientContext context;
    private CardValidator cardValidator;

    public VirgilClient(String accessToken) {
        this.context = new VirgilClientContext(accessToken);
    }

    public VirgilClient(VirgilClientContext context) {
        this.context = context;
    }

    @Deprecated
    private String verify(String type, String value) {
        return null;
    }

    @Deprecated
    private Identity confirm(String actionId, String confirmationCode, Token confirmationToken) {
        return null;
    }

    public Card createCard(CreateCardRequest request) throws VirgilServiceException {
        try {
            URL url = new URL(this.context.getCardsServiceURL(), "/v4/card");
            String body = ConvertionUtils.getGson().toJson((Object)request.getRequestModel());
            SignedResponseModel responseModel = this.execute(url, "POST", new ByteArrayInputStream(ConvertionUtils.toBytes(body)), SignedResponseModel.class);
            return this.responseToCard(responseModel);
        }
        catch (VirgilServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VirgilCardServiceException(e);
        }
    }

    public Card getCard(String cardId) {
        try {
            URL url = new URL(this.context.getReadOnlyCardsServiceURL(), "/v4/card/" + cardId);
            SignedResponseModel responseModel = this.execute(url, "GET", null, SignedResponseModel.class);
            Card card = this.responseToCard(responseModel);
            this.validateCards(Arrays.asList(card));
            return card;
        }
        catch (VirgilServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VirgilCardServiceException(e);
        }
    }

    private HttpURLConnection createConnection(URL url, String method) throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod(method);
        urlConnection.setUseCaches(false);
        switch (method) {
            case "DELETE": 
            case "POST": 
            case "PUT": 
            case "PATCH": {
                urlConnection.setDoOutput(true);
                urlConnection.setChunkedStreamingMode(0);
                break;
            }
        }
        urlConnection.setRequestProperty("Authorization", "VIRGIL " + this.context.getAccessToken());
        urlConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        return urlConnection;
    }

    public void revokeCard(RevokeCardRequest request) {
        try {
            URL url = new URL(this.context.getCardsServiceURL(), "/v4/card/" + request.getCardId());
            String body = ConvertionUtils.getGson().toJson((Object)request.getRequestModel());
            this.execute(url, "DELETE", new ByteArrayInputStream(ConvertionUtils.toBytes(body)), Void.class);
        }
        catch (VirgilServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VirgilCardServiceException(e);
        }
    }

    public List<Card> searchCards(SearchCriteria criteria) {
        if (criteria == null) {
            throw new NullArgumentException("criteria");
        }
        if (criteria.getIdentities().isEmpty()) {
            throw new EmptyArgumentException("criteria");
        }
        SearchRequest body = new SearchRequest();
        body.setIdentities(criteria.getIdentities());
        if (!StringUtils.isBlank(criteria.getIdentityType())) {
            body.setIdentityType(criteria.getIdentityType());
        }
        if (criteria.getScope() == CardScope.GLOBAL) {
            body.setScope(criteria.getScope());
        }
        try {
            URL url = new URL(this.context.getReadOnlyCardsServiceURL(), "/v4/card/actions/search");
            SignedResponseModel[] responseModels = this.execute(url, "POST", new ByteArrayInputStream(ConvertionUtils.toBytes(ConvertionUtils.getGson().toJson((Object)body))), SignedResponseModel[].class);
            ArrayList<Card> cards = new ArrayList<Card>();
            for (SignedResponseModel responseModel : responseModels) {
                cards.add(this.responseToCard(responseModel));
            }
            this.validateCards(cards);
            return cards;
        }
        catch (VirgilServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VirgilCardServiceException(e);
        }
    }

    private Card responseToCard(SignedResponseModel responseModel) {
        CreateCardModel model = (CreateCardModel)ConvertionUtils.getGson().fromJson(ConvertionUtils.base64ToString(responseModel.getContentSnapshot()), CreateCardModel.class);
        Card card = new Card();
        card.setId(responseModel.getCardId());
        card.setSnapshot(ConvertionUtils.base64ToBytes(responseModel.getContentSnapshot()));
        card.setIdentity(model.getIdentity());
        card.setIdentityType(model.getIdentityType());
        card.setPublicKey(ConvertionUtils.base64ToBytes(model.getPublicKey()));
        if (model.getInfo() != null) {
            card.setDevice(model.getInfo().getDevice());
            card.setDeviceName(model.getInfo().getDeviceName());
        }
        if (model.getData() != null) {
            card.setData(Collections.unmodifiableMap(model.getData()));
        }
        card.setScope(model.getScope());
        card.setVersion(responseModel.getMeta().getVersion());
        HashMap<String, byte[]> signatures = new HashMap<String, byte[]>();
        if (responseModel.getMeta() != null && responseModel.getMeta().getSignatures() != null) {
            for (Map.Entry<String, String> entry : responseModel.getMeta().getSignatures().entrySet()) {
                signatures.put(entry.getKey(), ConvertionUtils.base64ToBytes(entry.getValue()));
            }
        }
        card.setSignatures(signatures);
        return card;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(URL url, String method, InputStream inputStream, Class<T> clazz) {
        try {
            HttpURLConnection urlConnection = this.createConnection(url, method);
            if (inputStream != null) {
                StreamUtils.copyStream(inputStream, urlConnection.getOutputStream());
            }
            try {
                Object object;
                if (urlConnection.getResponseCode() >= 400) {
                    try (BufferedInputStream in = new BufferedInputStream(urlConnection.getErrorStream());){
                        String body = ConvertionUtils.toString(in);
                        if (!StringUtils.isBlank(body)) {
                            ErrorResponse error = (ErrorResponse)ConvertionUtils.getGson().fromJson(body, ErrorResponse.class);
                            throw new VirgilCardServiceException(error.getCode());
                        }
                    }
                    throw new VirgilCardServiceException();
                }
                if (clazz.isAssignableFrom(Void.class)) {
                    T in = null;
                    return in;
                }
                try (BufferedInputStream instream = new BufferedInputStream(urlConnection.getInputStream());){
                    String body = ConvertionUtils.toString(instream);
                    object = ConvertionUtils.getGson().fromJson(body, clazz);
                }
                return (T)object;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                urlConnection.disconnect();
            }
        }
        catch (IOException e) {
            throw new VirgilCardServiceException(e);
        }
    }

    private void validateCards(Collection<Card> cards) {
        if (this.cardValidator == null) {
            return;
        }
        ArrayList<Card> invalidCards = new ArrayList<Card>();
        for (Card card : cards) {
            if (this.cardValidator.validate(card)) continue;
            invalidCards.add(card);
        }
        if (!invalidCards.isEmpty()) {
            throw new CardValidationException(invalidCards);
        }
    }

    public void setCardValidator(CardValidator cardValidator) {
        if (cardValidator == null) {
            throw new NullArgumentException("cardValidator");
        }
        this.cardValidator = cardValidator;
    }
}

