/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.crypto;

import com.virgilsecurity.crypto.VirgilDataSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class VirgilStreamDataSource
extends VirgilDataSource
implements Closeable {
    private InputStream stream;
    private int chunkSize;
    private static int CHUNK_SIZE_DEFAULT = 0x100000;

    public VirgilStreamDataSource(InputStream stream) {
        this.stream = stream;
        this.chunkSize = CHUNK_SIZE_DEFAULT;
    }

    public VirgilStreamDataSource(InputStream stream, int chunkSize) {
        this.stream = stream;
        this.chunkSize = chunkSize;
    }

    @Override
    public boolean hasData() throws IOException {
        return this.stream.available() > 0;
    }

    @Override
    public byte[] read() throws IOException {
        int bytesToReadNum = Math.min(this.stream.available(), this.chunkSize);
        byte[] result = new byte[bytesToReadNum];
        this.stream.read(result, 0, bytesToReadNum);
        return result;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        this.delete();
    }
}

