/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.highlevel;

import com.virgilsecurity.sdk.client.utils.ConvertionUtils;
import com.virgilsecurity.sdk.client.utils.StringUtils;
import com.virgilsecurity.sdk.crypto.Crypto;
import com.virgilsecurity.sdk.crypto.PublicKey;
import com.virgilsecurity.sdk.crypto.exceptions.EmptyArgumentException;
import com.virgilsecurity.sdk.highlevel.VirgilCard;
import com.virgilsecurity.sdk.highlevel.VirgilConfig;
import java.util.ArrayList;

public class VirgilCards
extends ArrayList<VirgilCard> {
    private static final long serialVersionUID = -851151724028601817L;

    public byte[] encryptText(String text) {
        if (StringUtils.isBlank(text)) {
            throw new EmptyArgumentException("text");
        }
        return this.encrypt(ConvertionUtils.toBytes(text));
    }

    public byte[] encrypt(byte[] data) {
        if (this.isEmpty()) {
            throw new EmptyArgumentException("recipients");
        }
        Crypto crypto = VirgilConfig.getService(Crypto.class);
        ArrayList<PublicKey> publicKeys = new ArrayList<PublicKey>();
        for (VirgilCard recipient : this) {
            publicKeys.add(crypto.importPublicKey(recipient.getPublicKey()));
        }
        byte[] cipherdata = crypto.encrypt(data, publicKeys.toArray(new PublicKey[0]));
        return cipherdata;
    }
}

