/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.requests;

import com.virgilsecurity.sdk.client.model.CardScope;
import com.virgilsecurity.sdk.client.model.dto.CreateCardModel;
import com.virgilsecurity.sdk.client.model.dto.DeviceInfo;
import com.virgilsecurity.sdk.client.requests.SignedRequest;
import com.virgilsecurity.sdk.client.utils.ConvertionUtils;
import java.util.HashMap;
import java.util.Map;

public class CreateCardRequest
extends SignedRequest {
    private String identity;
    private String identityType;
    private String publicKey;
    private DeviceInfo info;
    private Map<String, String> data;

    public CreateCardRequest() {
    }

    public CreateCardRequest(String identity, String identityType, byte[] publicKey) {
        this(identity, identityType, publicKey, null, null);
    }

    public CreateCardRequest(String identity, String identityType, byte[] publicKey, Map<String, String> data) {
        this(identity, identityType, publicKey, data, null);
    }

    public CreateCardRequest(String identity, String identityType, byte[] publicKey, Map<String, String> data, DeviceInfo info) {
        this.identity = identity;
        this.identityType = identityType;
        this.publicKey = ConvertionUtils.toBase64String(publicKey);
        this.data = new HashMap<String, String>();
        if (data != null) {
            this.data.putAll(data);
        }
        this.info = info;
    }

    @Override
    protected void restoreRequest(String snapshot, Map<String, String> signatures) {
        this.snapshot = snapshot;
        this.signatures = new HashMap();
        if (signatures != null) {
            this.signatures.putAll(signatures);
        }
        CreateCardModel details = (CreateCardModel)ConvertionUtils.getGson().fromJson(ConvertionUtils.base64ToString(this.snapshot), CreateCardModel.class);
        this.identity = details.getIdentity();
        this.identityType = details.getIdentityType();
        this.publicKey = details.getPublicKey();
        this.data = new HashMap<String, String>();
        if (details.getData() != null) {
            this.data.putAll(details.getData());
        }
        this.info = details.getInfo();
    }

    @Override
    protected String takeSnapshot() {
        CreateCardModel model = new CreateCardModel();
        model.setIdentity(this.identity);
        model.setIdentityType(this.identityType);
        model.setPublicKey(this.publicKey);
        model.setData(this.data);
        model.setScope(CardScope.APPLICATION);
        model.setInfo(this.info);
        String json = ConvertionUtils.getGson().toJson((Object)model);
        return ConvertionUtils.toBase64String(json);
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getIdentityType() {
        return this.identityType;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public DeviceInfo getInfo() {
        return this.info;
    }

    public Map<String, String> getData() {
        return this.data;
    }
}

