/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.exceptions;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class VirgilServiceException
extends RuntimeException {
    private static final long serialVersionUID = -1143173438484224903L;
    protected static final String ERROR_UNKNOWN = "Unknown error";
    private int errorCode = 0;

    public VirgilServiceException() {
    }

    public VirgilServiceException(int code) {
        this.errorCode = code;
    }

    public VirgilServiceException(int code, Exception cause) {
        super(cause);
        this.errorCode = code;
    }

    public VirgilServiceException(Exception cause) {
        super(cause);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(this.getMessageBundleName());
            String key = String.valueOf(this.errorCode);
            if (bundle.containsKey(key)) {
                return bundle.getString(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return "Unknown error: " + this.errorCode;
    }

    protected abstract String getMessageBundleName();
}

