/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client;

import com.virgilsecurity.sdk.client.CardValidator;
import com.virgilsecurity.sdk.client.VirgilClientContext;
import com.virgilsecurity.sdk.client.exceptions.CardValidationException;
import com.virgilsecurity.sdk.client.exceptions.VirgilCardServiceException;
import com.virgilsecurity.sdk.client.exceptions.VirgilIdentityServiceException;
import com.virgilsecurity.sdk.client.exceptions.VirgilServiceException;
import com.virgilsecurity.sdk.client.model.Card;
import com.virgilsecurity.sdk.client.model.CardScope;
import com.virgilsecurity.sdk.client.model.dto.CreateCardModel;
import com.virgilsecurity.sdk.client.model.dto.SearchCriteria;
import com.virgilsecurity.sdk.client.model.dto.SearchRequest;
import com.virgilsecurity.sdk.client.model.dto.SignedResponseModel;
import com.virgilsecurity.sdk.client.model.identity.Action;
import com.virgilsecurity.sdk.client.model.identity.Confirmation;
import com.virgilsecurity.sdk.client.model.identity.Identity;
import com.virgilsecurity.sdk.client.model.identity.Token;
import com.virgilsecurity.sdk.client.requests.CreateCardRequest;
import com.virgilsecurity.sdk.client.requests.RevokeCardRequest;
import com.virgilsecurity.sdk.client.utils.ConvertionUtils;
import com.virgilsecurity.sdk.client.utils.StringUtils;
import com.virgilsecurity.sdk.crypto.exceptions.EmptyArgumentException;
import com.virgilsecurity.sdk.crypto.exceptions.NullArgumentException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class VirgilClient {
    private VirgilClientContext context;
    private CardValidator cardValidator;

    public VirgilClient(String accessToken) {
        this.context = new VirgilClientContext(accessToken);
    }

    public VirgilClient(VirgilClientContext context) {
        this.context = context;
    }

    @Deprecated
    private String verify(String type, String value) {
        String body = ConvertionUtils.getGson().toJson((Object)new Identity(type, value));
        try {
            URIBuilder builder = new URIBuilder(this.context.getIdentityServiceAddress());
            builder.setPath("/v1/verify");
            HttpPost postRequest = (HttpPost)this.createRequest("POST");
            postRequest.setURI(builder.build());
            postRequest.setEntity((HttpEntity)new StringEntity(body));
            Action action = this.execute((HttpRequestBase)postRequest, Action.class);
            return action.getActionId();
        }
        catch (Exception e) {
            throw new VirgilIdentityServiceException(e);
        }
    }

    @Deprecated
    private Identity confirm(String actionId, String confirmationCode, Token confirmationToken) {
        Confirmation confirmation = new Confirmation();
        confirmation.setActionId(actionId);
        confirmation.setConfirmationCode(confirmationCode);
        confirmation.setToken(confirmationToken);
        String body = ConvertionUtils.getGson().toJson((Object)confirmation);
        try {
            URIBuilder builder = new URIBuilder(this.context.getIdentityServiceAddress());
            builder.setPath("/v1/confirm");
            HttpPost postRequest = (HttpPost)this.createRequest("POST");
            postRequest.setURI(builder.build());
            postRequest.setEntity((HttpEntity)new StringEntity(body));
            Identity identity = this.execute((HttpRequestBase)postRequest, Identity.class);
            return identity;
        }
        catch (Exception e) {
            throw new VirgilIdentityServiceException(e);
        }
    }

    public Card createCard(CreateCardRequest request) throws VirgilServiceException {
        try {
            URIBuilder builder = new URIBuilder(this.context.getCardsServiceAddress());
            builder.setPath("/v4/card");
            HttpPost postRequest = (HttpPost)this.createRequest("POST");
            postRequest.setURI(builder.build());
            String body = ConvertionUtils.getGson().toJson((Object)request.getRequestModel());
            postRequest.setEntity((HttpEntity)new StringEntity(body));
            SignedResponseModel responseModel = this.execute((HttpRequestBase)postRequest, SignedResponseModel.class);
            return this.responseToCard(responseModel);
        }
        catch (VirgilServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VirgilCardServiceException(e);
        }
    }

    public Card getCard(String cardId) {
        try {
            URIBuilder builder = new URIBuilder(this.context.getReadOnlyCardsServiceAddress());
            builder.setPath("/v4/card/" + cardId);
            HttpGet postRequest = (HttpGet)this.createRequest("GET");
            postRequest.setURI(builder.build());
            SignedResponseModel responseModel = this.execute((HttpRequestBase)postRequest, SignedResponseModel.class);
            Card card = this.responseToCard(responseModel);
            this.validateCards(Arrays.asList(card));
            return card;
        }
        catch (VirgilServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VirgilCardServiceException(e);
        }
    }

    public void revokeCard(RevokeCardRequest request) {
        try {
            URIBuilder builder = new URIBuilder(this.context.getCardsServiceAddress());
            builder.setPath("/v4/card/" + request.getCardId());
            HttpEntityEnclosingRequestBase postRequest = (HttpEntityEnclosingRequestBase)this.createRequest("DELETE");
            postRequest.setURI(builder.build());
            postRequest.setEntity((HttpEntity)new StringEntity(ConvertionUtils.getGson().toJson((Object)request.getRequestModel())));
            this.execute((HttpRequestBase)postRequest, Void.class);
        }
        catch (VirgilServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VirgilCardServiceException(e);
        }
    }

    public List<Card> searchCards(SearchCriteria criteria) {
        if (criteria == null) {
            throw new NullArgumentException("criteria");
        }
        if (criteria.getIdentities().isEmpty()) {
            throw new EmptyArgumentException("criteria");
        }
        SearchRequest body = new SearchRequest();
        body.setIdentities(criteria.getIdentities());
        if (!StringUtils.isBlank(criteria.getIdentityType())) {
            body.setIdentityType(criteria.getIdentityType());
        }
        if (criteria.getScope() == CardScope.GLOBAL) {
            body.setScope(criteria.getScope());
        }
        try {
            URIBuilder builder = new URIBuilder(this.context.getReadOnlyCardsServiceAddress());
            builder.setPath("/v4/card/actions/search");
            HttpPost postRequest = (HttpPost)this.createRequest("POST");
            postRequest.setURI(builder.build());
            postRequest.setEntity((HttpEntity)new StringEntity(ConvertionUtils.getGson().toJson((Object)body)));
            SignedResponseModel[] responseModels = this.execute((HttpRequestBase)postRequest, SignedResponseModel[].class);
            ArrayList<Card> cards = new ArrayList<Card>();
            for (SignedResponseModel responseModel : responseModels) {
                cards.add(this.responseToCard(responseModel));
            }
            this.validateCards(cards);
            return cards;
        }
        catch (VirgilServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VirgilCardServiceException(e);
        }
    }

    private Card responseToCard(SignedResponseModel responseModel) {
        CreateCardModel model = (CreateCardModel)ConvertionUtils.getGson().fromJson(ConvertionUtils.base64ToString(responseModel.getContentSnapshot()), CreateCardModel.class);
        Card card = new Card();
        card.setId(responseModel.getCardId());
        card.setSnapshot(ConvertionUtils.base64ToArray(responseModel.getContentSnapshot()));
        card.setIdentity(model.getIdentity());
        card.setIdentityType(model.getIdentityType());
        card.setPublicKey(ConvertionUtils.base64ToArray(model.getPublicKey()));
        if (model.getInfo() != null) {
            card.setDevice(model.getInfo().getDevice());
            card.setDeviceName(model.getInfo().getDeviceName());
        }
        if (model.getData() != null) {
            card.setData(Collections.unmodifiableMap(model.getData()));
        }
        card.setScope(model.getScope());
        card.setVersion(responseModel.getMeta().getVersion());
        HashMap<String, byte[]> signatures = new HashMap<String, byte[]>();
        if (responseModel.getMeta() != null && responseModel.getMeta().getSignatures() != null) {
            for (Map.Entry<String, String> entry : responseModel.getMeta().getSignatures().entrySet()) {
                signatures.put(entry.getKey(), ConvertionUtils.base64ToArray(entry.getValue()));
            }
        }
        card.setSignatures(signatures);
        return card;
    }

    private CloseableHttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

    private HttpRequestBase createRequest(String method) {
        Object requestBase = null;
        switch (method) {
            case "POST": {
                requestBase = new HttpPost();
                break;
            }
            case "DELETE": {
                requestBase = new HttpEntityEnclosingRequestBase(){

                    public String getMethod() {
                        return "DELETE";
                    }
                };
                break;
            }
            default: {
                requestBase = new HttpGet();
            }
        }
        requestBase.addHeader("Authorization", "VIRGIL " + this.context.getAccessToken());
        requestBase.addHeader("Content-Type", "application/json; charset=utf-8");
        return requestBase;
    }

    /*
     * Exception decompiling
     */
    private <T> T execute(HttpRequestBase requestBase, Class<T> clazz) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateCards(Collection<Card> cards) {
        if (this.cardValidator == null) {
            return;
        }
        ArrayList<Card> invalidCards = new ArrayList<Card>();
        for (Card card : cards) {
            if (this.cardValidator.validate(card)) continue;
            invalidCards.add(card);
        }
        if (!invalidCards.isEmpty()) {
            throw new CardValidationException(invalidCards);
        }
    }

    public void setCardValidator(CardValidator cardValidator) {
        if (cardValidator == null) {
            throw new NullArgumentException("cardValidator");
        }
        this.cardValidator = cardValidator;
    }
}

