/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client;

import com.virgilsecurity.sdk.client.requests.SignedRequest;
import com.virgilsecurity.sdk.client.utils.ConvertionUtils;
import com.virgilsecurity.sdk.crypto.Crypto;
import com.virgilsecurity.sdk.crypto.Fingerprint;
import com.virgilsecurity.sdk.crypto.PrivateKey;

public class RequestSigner {
    private final Crypto crypto;

    public RequestSigner(Crypto crypto) {
        this.crypto = crypto;
    }

    public void selfSign(SignedRequest request, PrivateKey privateKey) {
        Fingerprint fingerprint = this.crypto.calculateFingerprint(ConvertionUtils.base64ToArray(request.getSnapshot()));
        byte[] signature = this.crypto.sign(fingerprint.getValue(), privateKey);
        request.appendSignature(fingerprint.toHex(), ConvertionUtils.toBase64String(signature));
    }

    public void authoritySign(SignedRequest request, String appdId, PrivateKey appKey) {
        Fingerprint fingerprint = this.crypto.calculateFingerprint(ConvertionUtils.base64ToArray(request.getSnapshot()));
        byte[] signature = this.crypto.sign(fingerprint.getValue(), appKey);
        request.appendSignature(appdId, ConvertionUtils.toBase64String(signature));
    }
}

