/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.crypto;

import com.virgilsecurity.crypto.VirgilAsn1Compatible;
import com.virgilsecurity.crypto.virgil_crypto_javaJNI;

public class VirgilHash
extends VirgilAsn1Compatible
implements AutoCloseable {
    private transient long swigCPtr;

    protected VirgilHash(long cPtr, boolean cMemoryOwn) {
        super(virgil_crypto_javaJNI.VirgilHash_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(VirgilHash obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                virgil_crypto_javaJNI.delete_VirgilHash(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    @Override
    public void close() {
        this.delete();
    }

    public VirgilHash() {
        this(virgil_crypto_javaJNI.new_VirgilHash__SWIG_0(), true);
    }

    public VirgilHash(Algorithm alg) {
        this(virgil_crypto_javaJNI.new_VirgilHash__SWIG_1(alg.swigValue()), true);
    }

    public VirgilHash(String name) {
        this(virgil_crypto_javaJNI.new_VirgilHash__SWIG_2(name), true);
    }

    public String name() {
        return virgil_crypto_javaJNI.VirgilHash_name(this.swigCPtr, this);
    }

    public int type() {
        return virgil_crypto_javaJNI.VirgilHash_type(this.swigCPtr, this);
    }

    public byte[] hash(byte[] data) {
        return virgil_crypto_javaJNI.VirgilHash_hash(this.swigCPtr, this, data);
    }

    public void start() {
        virgil_crypto_javaJNI.VirgilHash_start(this.swigCPtr, this);
    }

    public void update(byte[] data) {
        virgil_crypto_javaJNI.VirgilHash_update(this.swigCPtr, this, data);
    }

    public byte[] finish() {
        return virgil_crypto_javaJNI.VirgilHash_finish(this.swigCPtr, this);
    }

    public byte[] hmac(byte[] key, byte[] data) {
        return virgil_crypto_javaJNI.VirgilHash_hmac(this.swigCPtr, this, key, data);
    }

    public void hmacStart(byte[] key) {
        virgil_crypto_javaJNI.VirgilHash_hmacStart(this.swigCPtr, this, key);
    }

    public void hmacReset() {
        virgil_crypto_javaJNI.VirgilHash_hmacReset(this.swigCPtr, this);
    }

    public void hmacUpdate(byte[] data) {
        virgil_crypto_javaJNI.VirgilHash_hmacUpdate(this.swigCPtr, this, data);
    }

    public byte[] hmacFinish() {
        return virgil_crypto_javaJNI.VirgilHash_hmacFinish(this.swigCPtr, this);
    }

    public static final class Algorithm {
        public static final Algorithm MD5 = new Algorithm("MD5");
        public static final Algorithm SHA1 = new Algorithm("SHA1");
        public static final Algorithm SHA224 = new Algorithm("SHA224");
        public static final Algorithm SHA256 = new Algorithm("SHA256");
        public static final Algorithm SHA384 = new Algorithm("SHA384");
        public static final Algorithm SHA512 = new Algorithm("SHA512");
        private static Algorithm[] swigValues = new Algorithm[]{MD5, SHA1, SHA224, SHA256, SHA384, SHA512};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static Algorithm swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && Algorithm.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (Algorithm.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + Algorithm.class + " with value " + swigValue);
        }

        private Algorithm(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private Algorithm(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private Algorithm(String swigName, Algorithm swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

