/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.highlevel;

import com.virgilsecurity.sdk.client.VirgilClient;
import com.virgilsecurity.sdk.client.exceptions.VirgilCardIsNotFoundException;
import com.virgilsecurity.sdk.client.model.Card;
import com.virgilsecurity.sdk.client.model.CardScope;
import com.virgilsecurity.sdk.client.model.GlobalIdentityType;
import com.virgilsecurity.sdk.client.model.dto.SearchCriteria;
import com.virgilsecurity.sdk.client.requests.CreateCardRequest;
import com.virgilsecurity.sdk.client.requests.RevokeCardRequest;
import com.virgilsecurity.sdk.client.utils.ConvertionUtils;
import com.virgilsecurity.sdk.client.utils.StringUtils;
import com.virgilsecurity.sdk.crypto.Crypto;
import com.virgilsecurity.sdk.crypto.PublicKey;
import com.virgilsecurity.sdk.crypto.exceptions.EmptyArgumentException;
import com.virgilsecurity.sdk.crypto.exceptions.NullArgumentException;
import com.virgilsecurity.sdk.highlevel.VirgilCards;
import com.virgilsecurity.sdk.highlevel.VirgilConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class VirgilCard {
    private Card model;

    VirgilCard(Card model) {
        this.model = model;
    }

    public byte[] encrypt(byte[] data) {
        if (data == null) {
            throw new NullArgumentException("data");
        }
        Crypto crypto = VirgilConfig.getService(Crypto.class);
        PublicKey publicKey = crypto.importPublicKey(this.getPublicKey());
        byte[] cipherdata = crypto.encrypt(data, publicKey);
        return cipherdata;
    }

    public boolean verify(byte[] data, byte[] signature) {
        if (data == null) {
            throw new NullArgumentException("data");
        }
        if (signature == null) {
            throw new NullArgumentException("signature");
        }
        Crypto crypto = VirgilConfig.getService(Crypto.class);
        PublicKey publicKey = crypto.importPublicKey(this.getPublicKey());
        boolean isValid = crypto.verify(data, signature, publicKey);
        return isValid;
    }

    public static VirgilCard get(String cardId) {
        VirgilClient client = VirgilConfig.getService(VirgilClient.class);
        Card virgilCardDto = client.getCard(cardId);
        if (virgilCardDto == null) {
            throw new VirgilCardIsNotFoundException();
        }
        return new VirgilCard(virgilCardDto);
    }

    public static VirgilCards findGlobal(String identity) {
        return VirgilCard.findGlobal(identity, GlobalIdentityType.EMAIL);
    }

    public static VirgilCards findGlobal(String identity, GlobalIdentityType type) {
        if (identity == null) {
            throw new NullArgumentException("identity");
        }
        return VirgilCard.findGlobal(Arrays.asList(identity), type);
    }

    public static VirgilCards findGlobal(List<String> identities) {
        return VirgilCard.findGlobal(identities, GlobalIdentityType.EMAIL);
    }

    public static VirgilCards findGlobal(List<String> identities, GlobalIdentityType type) {
        if (identities == null) {
            throw new NullArgumentException("identities");
        }
        VirgilClient client = VirgilConfig.getService(VirgilClient.class);
        SearchCriteria criteria = new SearchCriteria();
        criteria.addIdentities(identities);
        criteria.setIdentityType(type.getValue());
        criteria.setScope(CardScope.GLOBAL);
        List<Card> cardModels = client.searchCards(criteria);
        VirgilCards virgilCards = new VirgilCards();
        for (Card card : cardModels) {
            virgilCards.add(new VirgilCard(card));
        }
        return virgilCards;
    }

    public static VirgilCards find(String identity, String type) {
        if (identity == null) {
            throw new NullArgumentException("identity");
        }
        return VirgilCard.find(Arrays.asList(identity), type);
    }

    public static VirgilCards find(List<String> identities, String type) {
        if (identities == null) {
            throw new NullArgumentException("identities");
        }
        for (String identity : identities) {
            if (identity != null) continue;
            throw new NullArgumentException("identity");
        }
        VirgilClient client = VirgilConfig.getService(VirgilClient.class);
        SearchCriteria criteria = SearchCriteria.byIdentities(identities);
        criteria.setIdentityType(type);
        List<Card> cardModels = client.searchCards(criteria);
        VirgilCards virgilCards = new VirgilCards();
        for (Card card : cardModels) {
            virgilCards.add(new VirgilCard(card));
        }
        return virgilCards;
    }

    public static VirgilCard create(CreateCardRequest request) {
        VirgilClient client = VirgilConfig.getService(VirgilClient.class);
        Card card = client.createCard(request);
        return new VirgilCard(card);
    }

    public static void revoke(RevokeCardRequest request) {
        VirgilClient client = VirgilConfig.getService(VirgilClient.class);
        client.revokeCard(request);
    }

    public byte[] encryptText(String text) {
        if (StringUtils.isBlank(text)) {
            throw new EmptyArgumentException("text");
        }
        return this.encrypt(ConvertionUtils.toBytes(text));
    }

    public boolean verifyText(String text, byte[] signature) {
        if (StringUtils.isBlank(text)) {
            throw new EmptyArgumentException("text");
        }
        return this.verify(ConvertionUtils.toBytes(text), signature);
    }

    public String getId() {
        return this.model.getId();
    }

    public String getIdentity() {
        return this.model.getIdentity();
    }

    public String getIdentityType() {
        return this.model.getIdentityType();
    }

    public Map<String, String> getData() {
        return this.model.getData();
    }

    public byte[] getPublicKey() {
        return this.model.getPublicKey();
    }
}

