/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.highlevel;

import com.virgilsecurity.sdk.client.exceptions.ServiceIsAlreadyRegisteredException;
import com.virgilsecurity.sdk.client.exceptions.ServiceNotRegisteredException;
import com.virgilsecurity.sdk.crypto.exception.VirgilException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceContainer {
    private Map<Class<?>, RegisteredObject> registeredObjects = new ConcurrentHashMap();

    public void registerSingleton(Class<?> resolvedType, Class<?> instanceType) {
        this.register(resolvedType, new RegisteredObject(instanceType));
    }

    public void registerInstance(Class<?> resolvedType, Object instance) {
        this.register(resolvedType, new RegisteredObject(instance.getClass(), instance));
    }

    public <T> T resolve(Class<T> type) {
        RegisteredObject registeredObject = this.registeredObjects.get(type);
        if (registeredObject == null) {
            throw new ServiceNotRegisteredException(String.format("The type %1$s has not been registered", type.getCanonicalName()));
        }
        return (T)this.getInstance(registeredObject);
    }

    private Object getInstance(RegisteredObject registeredObject) {
        if (registeredObject.getInstance() != null) {
            return registeredObject.getInstance();
        }
        try {
            Constructor<?>[] constructors = registeredObject.getType().getConstructors();
            Arrays.sort(constructors, new Comparator<Constructor<?>>(){

                @Override
                public int compare(Constructor<?> o1, Constructor<?> o2) {
                    return o1.getParameterCount() - o2.getParameterCount();
                }
            });
            Constructor<?> constructor = constructors[0];
            Object instance = constructor.newInstance(this.resolveConstructorParameters(constructor));
            registeredObject.setInstance(instance);
            return instance;
        }
        catch (Exception e) {
            throw new VirgilException(e);
        }
    }

    private Object[] resolveConstructorParameters(Constructor<?> constructor) {
        Class<?>[] types = constructor.getParameterTypes();
        Object[] params = new Object[types.length];
        int i = 0;
        for (Class<?> type : types) {
            params[i++] = this.resolve(type);
        }
        return params;
    }

    public void remove(Type type) {
        this.registeredObjects.remove(type);
    }

    public void clear() {
        this.registeredObjects.clear();
    }

    private void register(Class<?> resolvedType, RegisteredObject registeredObject) {
        if (this.registeredObjects.containsKey(resolvedType)) {
            throw new ServiceIsAlreadyRegisteredException();
        }
        this.registeredObjects.put(resolvedType, registeredObject);
    }

    private class RegisteredObject {
        private Class<?> type;
        private Object instance;

        public RegisteredObject(Class<?> type) {
            this.type = type;
        }

        public RegisteredObject(Class<?> type, Object instance) {
            this.type = type;
            this.instance = instance;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void setInstance(Object instance) {
            this.instance = instance;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

