/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.crypto;

import com.virgilsecurity.crypto.VirgilCipher;
import com.virgilsecurity.crypto.VirgilHash;
import com.virgilsecurity.crypto.VirgilKeyPair;
import com.virgilsecurity.crypto.VirgilSigner;
import com.virgilsecurity.crypto.VirgilStreamCipher;
import com.virgilsecurity.crypto.VirgilStreamDataSink;
import com.virgilsecurity.crypto.VirgilStreamDataSource;
import com.virgilsecurity.sdk.crypto.Crypto;
import com.virgilsecurity.sdk.crypto.Fingerprint;
import com.virgilsecurity.sdk.crypto.HashAlgorithm;
import com.virgilsecurity.sdk.crypto.KeyPair;
import com.virgilsecurity.sdk.crypto.KeysType;
import com.virgilsecurity.sdk.crypto.PrivateKey;
import com.virgilsecurity.sdk.crypto.PublicKey;
import com.virgilsecurity.sdk.crypto.VirgilFingerprint;
import com.virgilsecurity.sdk.crypto.VirgilPrivateKey;
import com.virgilsecurity.sdk.crypto.VirgilPublicKey;
import com.virgilsecurity.sdk.crypto.exception.CryptoException;
import com.virgilsecurity.sdk.crypto.exception.DecryptionException;
import com.virgilsecurity.sdk.crypto.exception.EncryptionException;
import com.virgilsecurity.sdk.crypto.exception.VerificationException;
import com.virgilsecurity.sdk.crypto.exceptions.NullArgumentException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class VirgilCrypto
implements Crypto {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final byte[] CUSTOM_PARAM_SIGNATURE = "VIRGIL-DATA-SIGNATURE".getBytes(UTF8_CHARSET);

    public static VirgilHash createVirgilHash(HashAlgorithm algorithm) {
        switch (algorithm) {
            case MD5: {
                return new VirgilHash(VirgilHash.Algorithm.MD5);
            }
            case SHA1: {
                return new VirgilHash(VirgilHash.Algorithm.SHA1);
            }
            case SHA224: {
                return new VirgilHash(VirgilHash.Algorithm.SHA224);
            }
            case SHA256: {
                return new VirgilHash(VirgilHash.Algorithm.SHA256);
            }
            case SHA384: {
                return new VirgilHash(VirgilHash.Algorithm.SHA384);
            }
            case SHA512: {
                return new VirgilHash(VirgilHash.Algorithm.SHA512);
            }
        }
        throw new IllegalArgumentException();
    }

    public static VirgilKeyPair.Type toVirgilKeyPairType(KeysType keysType) {
        switch (keysType) {
            case Default: {
                return VirgilKeyPair.Type.FAST_EC_ED25519;
            }
            case RSA_2048: {
                return VirgilKeyPair.Type.RSA_2048;
            }
            case RSA_3072: {
                return VirgilKeyPair.Type.RSA_3072;
            }
            case RSA_4096: {
                return VirgilKeyPair.Type.RSA_4096;
            }
            case RSA_8192: {
                return VirgilKeyPair.Type.RSA_8192;
            }
            case EC_SECP256R1: {
                return VirgilKeyPair.Type.EC_SECP256R1;
            }
            case EC_SECP384R1: {
                return VirgilKeyPair.Type.EC_SECP384R1;
            }
            case EC_SECP521R1: {
                return VirgilKeyPair.Type.EC_SECP521R1;
            }
            case EC_BP256R1: {
                return VirgilKeyPair.Type.EC_BP256R1;
            }
            case EC_BP384R1: {
                return VirgilKeyPair.Type.EC_BP384R1;
            }
            case EC_BP512R1: {
                return VirgilKeyPair.Type.EC_BP512R1;
            }
            case EC_SECP256K1: {
                return VirgilKeyPair.Type.EC_SECP256K1;
            }
            case EC_CURVE25519: {
                return VirgilKeyPair.Type.EC_CURVE25519;
            }
            case FAST_EC_X25519: {
                return VirgilKeyPair.Type.FAST_EC_X25519;
            }
            case FAST_EC_ED25519: {
                return VirgilKeyPair.Type.FAST_EC_ED25519;
            }
        }
        assert (false);
        return VirgilKeyPair.Type.FAST_EC_ED25519;
    }

    @Override
    public Fingerprint calculateFingerprint(byte[] content) {
        if (content == null) {
            throw new NullArgumentException("content");
        }
        try (VirgilHash sha256 = new VirgilHash(VirgilHash.Algorithm.SHA256);){
            byte[] hash = sha256.hash(content);
            VirgilFingerprint virgilFingerprint = new VirgilFingerprint(hash);
            return virgilFingerprint;
        }
    }

    @Override
    public byte[] computeHash(byte[] data, HashAlgorithm algorithm) {
        if (data == null) {
            throw new NullArgumentException("data");
        }
        try (VirgilHash hasher = VirgilCrypto.createVirgilHash(algorithm);){
            byte[] byArray = hasher.hash(data);
            return byArray;
        }
    }

    private byte[] computePublicKeyHash(byte[] publicKey) {
        byte[] publicKeyDER = VirgilKeyPair.publicKeyToDER(publicKey);
        return this.computeHash(publicKeyDER, HashAlgorithm.SHA256);
    }

    @Override
    public byte[] decrypt(byte[] cipherData, PrivateKey privateKey) {
        try (VirgilCipher cipher = new VirgilCipher();){
            byte[] decryptedData;
            byte[] byArray = decryptedData = cipher.decryptWithKey(cipherData, privateKey.getId(), privateKey.getValue());
            return byArray;
        }
    }

    @Override
    public void decrypt(InputStream inputStream, OutputStream outputStream, PrivateKey privateKey) throws DecryptionException {
        try (VirgilStreamCipher cipher = new VirgilStreamCipher();
             VirgilStreamDataSource dataSource = new VirgilStreamDataSource(inputStream);
             VirgilStreamDataSink dataSink = new VirgilStreamDataSink(outputStream);){
            cipher.decryptWithKey(dataSource, dataSink, privateKey.getId(), privateKey.getValue());
        }
        catch (IOException e) {
            throw new DecryptionException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] decryptThenVerify(byte[] cipherData, PrivateKey privateKey, PublicKey publicKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public byte[] encrypt(byte[] data, PublicKey recipient) {
        try (VirgilCipher cipher = new VirgilCipher();){
            byte[] encryptedData;
            cipher.addKeyRecipient(recipient.getId(), recipient.getValue());
            byte[] byArray = encryptedData = cipher.encrypt(data, true);
            return byArray;
        }
    }

    @Override
    public byte[] encrypt(byte[] data, PublicKey[] recipients) {
        try (VirgilCipher cipher = new VirgilCipher();){
            byte[] encryptedData;
            for (PublicKey recipient : recipients) {
                cipher.addKeyRecipient(recipient.getId(), recipient.getValue());
            }
            byte[] byArray = encryptedData = cipher.encrypt(data, true);
            return byArray;
        }
    }

    @Override
    public void encrypt(InputStream inputStream, OutputStream outputStream, PublicKey recipient) throws EncryptionException {
        try (VirgilStreamCipher cipher = new VirgilStreamCipher();
             VirgilStreamDataSource dataSource = new VirgilStreamDataSource(inputStream);
             VirgilStreamDataSink dataSink = new VirgilStreamDataSink(outputStream);){
            cipher.addKeyRecipient(recipient.getId(), recipient.getValue());
            cipher.encrypt(dataSource, dataSink, true);
        }
        catch (IOException e) {
            throw new EncryptionException(e);
        }
    }

    @Override
    public void encrypt(InputStream inputStream, OutputStream outputStream, PublicKey[] recipients) throws EncryptionException {
        try (VirgilStreamCipher cipher = new VirgilStreamCipher();
             VirgilStreamDataSource dataSource = new VirgilStreamDataSource(inputStream);
             VirgilStreamDataSink dataSink = new VirgilStreamDataSink(outputStream);){
            for (PublicKey recipient : recipients) {
                cipher.addKeyRecipient(recipient.getId(), recipient.getValue());
            }
            cipher.encrypt(dataSource, dataSink, true);
        }
        catch (IOException e) {
            throw new EncryptionException(e);
        }
    }

    @Override
    public byte[] exportPrivateKey(PrivateKey privateKey) {
        return this.exportPrivateKey(privateKey, null);
    }

    @Override
    public byte[] exportPrivateKey(PrivateKey privateKey, String password) {
        if (password == null) {
            return VirgilKeyPair.privateKeyToDER(privateKey.getValue());
        }
        byte[] passwordBytes = password.getBytes(UTF8_CHARSET);
        byte[] encryptedKey = VirgilKeyPair.encryptPrivateKey(privateKey.getValue(), passwordBytes);
        return VirgilKeyPair.privateKeyToDER(encryptedKey, passwordBytes);
    }

    @Override
    public byte[] exportPublicKey(PublicKey publicKey) {
        return VirgilKeyPair.publicKeyToDER(publicKey.getValue());
    }

    @Override
    public PublicKey extractPublicKey(PrivateKey privateKey) {
        byte[] publicKeyData = VirgilKeyPair.extractPublicKey(privateKey.getValue(), new byte[0]);
        byte[] receiverId = privateKey.getId();
        byte[] value = VirgilKeyPair.publicKeyToDER(publicKeyData);
        return new VirgilPublicKey(receiverId, value);
    }

    @Override
    public KeyPair generateKeys() {
        return this.generateKeys(KeysType.Default);
    }

    public KeyPair generateKeys(KeysType keysType) {
        VirgilKeyPair keyPair = VirgilKeyPair.generate(VirgilCrypto.toVirgilKeyPairType(keysType));
        byte[] keyPairId = this.computePublicKeyHash(keyPair.publicKey());
        VirgilPublicKey publicKey = new VirgilPublicKey(keyPairId, VirgilKeyPair.publicKeyToDER(keyPair.publicKey()));
        VirgilPrivateKey privateKey = new VirgilPrivateKey(keyPairId, VirgilKeyPair.privateKeyToDER(keyPair.privateKey()));
        return new KeyPair(publicKey, privateKey);
    }

    @Override
    public PrivateKey importPrivateKey(byte[] privateKey) throws CryptoException {
        return this.importPrivateKey(privateKey, null);
    }

    @Override
    public PrivateKey importPrivateKey(byte[] keyData, String password) throws CryptoException {
        if (keyData == null) {
            throw new NullArgumentException("keyData");
        }
        try {
            byte[] privateKeyBytes = password == null ? VirgilKeyPair.privateKeyToDER(keyData) : VirgilKeyPair.decryptPrivateKey(keyData, password.getBytes(UTF8_CHARSET));
            byte[] publicKey = VirgilKeyPair.extractPublicKey(privateKeyBytes, new byte[0]);
            byte[] receiverId = this.computePublicKeyHash(publicKey);
            byte[] value = VirgilKeyPair.privateKeyToDER(privateKeyBytes);
            VirgilPrivateKey privateKey = new VirgilPrivateKey(receiverId, value);
            return privateKey;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public PublicKey importPublicKey(byte[] publicKey) {
        byte[] receiverId = this.computePublicKeyHash(publicKey);
        byte[] value = VirgilKeyPair.publicKeyToDER(publicKey);
        return new VirgilPublicKey(receiverId, value);
    }

    @Override
    public byte[] sign(byte[] data, PrivateKey privateKey) {
        if (data == null) {
            throw new NullArgumentException("data");
        }
        if (privateKey == null) {
            throw new NullArgumentException("privateKey");
        }
        try (VirgilSigner signer = new VirgilSigner();){
            byte[] signature;
            byte[] byArray = signature = signer.sign(data, privateKey.getValue());
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] sign(InputStream inputStream, PrivateKey privateKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public byte[] signThenEncrypt(byte[] data, PrivateKey privateKey, PublicKey recipient) {
        return this.signThenEncrypt(data, privateKey, new PublicKey[]{recipient});
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] signThenEncrypt(byte[] data, PrivateKey privateKey, PublicKey[] recipients) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean verify(byte[] data, byte[] signature, PublicKey signer) {
        if (data == null) {
            throw new NullArgumentException("data");
        }
        if (signature == null) {
            throw new NullArgumentException("signature");
        }
        if (signer == null) {
            throw new NullArgumentException("signer");
        }
        try (VirgilSigner virgilSigner = new VirgilSigner();){
            boolean valid;
            boolean bl = valid = virgilSigner.verify(data, signature, signer.getValue());
            return bl;
        }
        catch (Exception e) {
            throw new VerificationException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean verify(InputStream inputStream, byte[] signature, PublicKey signer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

