/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.requests;

import com.virgilsecurity.sdk.client.model.RevocationReason;
import com.virgilsecurity.sdk.client.model.dto.RevokeCardModel;
import com.virgilsecurity.sdk.client.requests.SignedRequest;
import com.virgilsecurity.sdk.client.utils.ConvertionUtils;
import java.util.Map;

public class RevokeCardRequest
extends SignedRequest {
    private String cardId;
    private RevocationReason reason;

    public RevokeCardRequest(String cardId, RevocationReason reason) {
        this.cardId = cardId;
        this.reason = reason;
    }

    @Override
    protected void restoreRequest(String snapshot, Map<String, String> signatures) {
        this.snapshot = snapshot;
        this.signatures = signatures;
        RevokeCardModel details = (RevokeCardModel)ConvertionUtils.getGson().fromJson(this.snapshot, RevokeCardModel.class);
        this.cardId = details.getCardId();
        this.reason = details.getReason();
    }

    @Override
    protected String takeSnapshot() {
        RevokeCardModel model = new RevokeCardModel();
        model.setCardId(this.cardId);
        model.setReason(this.reason);
        String json = ConvertionUtils.getGson().toJson((Object)model);
        return ConvertionUtils.toBase64String(json);
    }

    public String getCardId() {
        return this.cardId;
    }

    public RevocationReason getReason() {
        return this.reason;
    }
}

