/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.http.interceptors;

import com.virgilsecurity.sdk.crypto.CryptoHelper;
import com.virgilsecurity.sdk.crypto.Password;
import com.virgilsecurity.sdk.crypto.PrivateKey;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class RequestSignInterceptor
implements Interceptor {
    private static final Logger LOGGER = Logger.getLogger(RequestSignInterceptor.class.getName());
    private PrivateKey privateKey;
    private Password password;

    public RequestSignInterceptor(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public RequestSignInterceptor(PrivateKey privateKey, Password password) {
        this(privateKey);
        this.password = password;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        String requestId = UUID.randomUUID().toString();
        Request.Builder requestBuilder = original.newBuilder().header("X-VIRGIL-REQUEST-ID", requestId);
        if (this.privateKey != null) {
            Buffer requestBody = new Buffer();
            original.body().writeTo((BufferedSink)requestBody);
            String requestText = requestId + requestBody.readUtf8();
            try {
                String sign = null;
                sign = this.password == null ? CryptoHelper.sign(requestText, this.privateKey) : CryptoHelper.sign(requestText, this.privateKey, this.password);
                requestBuilder.header("X-VIRGIL-REQUEST-SIGN", sign);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Can't sign request text", e);
            }
        }
        requestBuilder.method(original.method(), original.body());
        Request request = requestBuilder.build();
        return chain.proceed(request);
    }
}

