/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.crypto;

import java.nio.charset.Charset;

public class Password {
    private byte[] encoded;

    public Password(byte[] encoded) {
        this.setEncoded(encoded);
    }

    public Password(String password) {
        this(password, Charset.defaultCharset());
    }

    public Password(String password, Charset charset) {
        if (password == null) {
            throw new IllegalArgumentException("Password can't be null");
        }
        this.setEncoded(password.getBytes(charset));
    }

    private void setEncoded(byte[] encoded) {
        if (encoded == null) {
            throw new IllegalArgumentException("Password can't be null");
        }
        this.encoded = encoded;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public String toString() {
        return new String(this.encoded);
    }
}

