/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class APIError {
    private int statusCode;
    @SerializedName(value="code")
    private int errorCode;
    private String message;
    private Throwable throwable;

    public APIError(Throwable throwable) {
        this.throwable = throwable;
    }

    public APIError(int statusCode, String errorBody) {
        this.statusCode = statusCode;
        try {
            JsonElement bodyAsJson = new JsonParser().parse(errorBody);
            if (bodyAsJson.isJsonObject()) {
                this.errorCode = ((JsonObject)bodyAsJson).get("code").getAsInt();
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle("Messages");
            String key = this.getErrorPrefix() + this.errorCode;
            if (bundle.containsKey(key)) {
                return bundle.getString(key);
            }
            if (bundle.containsKey("error_unknown")) {
                return bundle.getString("error_unknown");
            }
            return "";
        }
        catch (MissingResourceException e) {
            return "";
        }
    }

    protected String getErrorPrefix() {
        return "error";
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("APIError { ");
        sb.append("statusCode = ").append(this.statusCode);
        sb.append(", ").append("errorCode = ").append(this.errorCode);
        sb.append(", ").append("message = ").append(this.getMessage());
        return sb.append(" }").toString();
    }
}

