/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.crypto;

import com.virgilsecurity.crypto.VirgilStreamCipher;
import com.virgilsecurity.crypto.VirgilStreamDataSink;
import com.virgilsecurity.crypto.VirgilStreamDataSource;
import com.virgilsecurity.sdk.crypto.CipherBase;
import com.virgilsecurity.sdk.crypto.Password;
import com.virgilsecurity.sdk.crypto.PrivateKey;
import com.virgilsecurity.sdk.crypto.Recipient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamCipher
extends CipherBase
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(StreamCipher.class.getName());
    private VirgilStreamCipher cipher = new VirgilStreamCipher();

    @Override
    public void close() throws Exception {
        this.cipher.close();
    }

    public void encrypt(InputStream inputStream, OutputStream outputStream, boolean embedContentInfo) {
        try (VirgilStreamDataSource dataSource = new VirgilStreamDataSource(inputStream);
             VirgilStreamDataSink dataSink = new VirgilStreamDataSink(outputStream);){
            this.cipher.encrypt(dataSource, dataSink, embedContentInfo);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can't close resource", e);
        }
    }

    public void encrypt(InputStream inputStream, OutputStream outputStream) {
        try (VirgilStreamDataSource dataSource = new VirgilStreamDataSource(inputStream);
             VirgilStreamDataSink dataSink = new VirgilStreamDataSink(outputStream);){
            this.cipher.encrypt(dataSource, dataSink);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can't close resource", e);
        }
    }

    public void decryptWithKey(InputStream inputStream, OutputStream outputStream, Recipient recipient, PrivateKey privateKey, Password privateKeyPassword) {
        try (VirgilStreamDataSource dataSource = new VirgilStreamDataSource(inputStream);
             VirgilStreamDataSink dataSink = new VirgilStreamDataSink(outputStream);){
            this.cipher.decryptWithKey(dataSource, dataSink, recipient.getId(), privateKey.getEncoded(), privateKeyPassword.getEncoded());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can't close resource", e);
        }
    }

    public void decryptWithKey(InputStream inputStream, OutputStream outputStream, Recipient recipient, PrivateKey privateKey) {
        try (VirgilStreamDataSource dataSource = new VirgilStreamDataSource(inputStream);
             VirgilStreamDataSink dataSink = new VirgilStreamDataSink(outputStream);){
            this.cipher.decryptWithKey(dataSource, dataSink, recipient.getId(), privateKey.getEncoded());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can't close resource", e);
        }
    }

    public void decryptWithPassword(InputStream inputStream, OutputStream outputStream, Password password) {
        try (VirgilStreamDataSource dataSource = new VirgilStreamDataSource(inputStream);
             VirgilStreamDataSink dataSink = new VirgilStreamDataSink(outputStream);){
            this.cipher.decryptWithPassword(dataSource, dataSink, password.getEncoded());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can't close resource", e);
        }
    }
}

