/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.crypto;

import com.virgilsecurity.crypto.VirgilKeyPair;
import com.virgilsecurity.sdk.crypto.KeyPair;
import com.virgilsecurity.sdk.crypto.KeyType;
import com.virgilsecurity.sdk.crypto.Password;

public class KeyPairGenerator {
    public static KeyPair generate() {
        return KeyPairGenerator.generate(KeyType.Default);
    }

    public static KeyPair generate(String password) {
        return KeyPairGenerator.generate(KeyType.Default, password);
    }

    public static KeyPair generate(KeyType keyType) {
        VirgilKeyPair pair = null;
        switch (keyType) {
            case Default: {
                pair = VirgilKeyPair.generate();
                break;
            }
            case EC_BP256R1: {
                pair = VirgilKeyPair.ecBrainpool256();
                break;
            }
            case EC_BP384R1: {
                pair = VirgilKeyPair.ecBrainpool384();
                break;
            }
            case EC_BP512R1: {
                pair = VirgilKeyPair.ecBrainpool512();
                break;
            }
            case EC_SECP192K1: {
                pair = VirgilKeyPair.ecKoblitz192();
                break;
            }
            case EC_SECP224K1: {
                pair = VirgilKeyPair.ecKoblitz224();
                break;
            }
            case EC_SECP256K1: {
                pair = VirgilKeyPair.ecKoblitz256();
                break;
            }
            case EC_SECP192R1: {
                pair = VirgilKeyPair.ecNist192();
                break;
            }
            case EC_SECP224R1: {
                pair = VirgilKeyPair.ecNist224();
                break;
            }
            case EC_SECP256R1: {
                pair = VirgilKeyPair.ecNist256();
                break;
            }
            case EC_SECP384R1: {
                pair = VirgilKeyPair.ecNist384();
                break;
            }
            case EC_SECP521R1: {
                pair = VirgilKeyPair.ecNist521();
                break;
            }
            case RSA_256: {
                pair = VirgilKeyPair.rsa256();
                break;
            }
            case RSA_512: {
                pair = VirgilKeyPair.rsa512();
                break;
            }
            case RSA_1024: {
                pair = VirgilKeyPair.rsa1024();
                break;
            }
            case RSA_2048: {
                pair = VirgilKeyPair.rsa2048();
                break;
            }
            case RSA_4096: {
                pair = VirgilKeyPair.rsa4096();
                break;
            }
            default: {
                throw new IllegalArgumentException("Key type " + (Object)((Object)keyType) + " is not supported");
            }
        }
        return new KeyPair(pair);
    }

    public static KeyPair generate(KeyType keyType, Password password) {
        VirgilKeyPair pair = null;
        switch (keyType) {
            case Default: {
                pair = VirgilKeyPair.generate(VirgilKeyPair.Type.Default, password.getEncoded());
                break;
            }
            case EC_BP256R1: {
                pair = VirgilKeyPair.ecBrainpool256(password.getEncoded());
                break;
            }
            case EC_BP384R1: {
                pair = VirgilKeyPair.ecBrainpool384(password.getEncoded());
                break;
            }
            case EC_BP512R1: {
                pair = VirgilKeyPair.ecBrainpool512(password.getEncoded());
                break;
            }
            case EC_SECP192K1: {
                pair = VirgilKeyPair.ecKoblitz192(password.getEncoded());
                break;
            }
            case EC_SECP224K1: {
                pair = VirgilKeyPair.ecKoblitz224(password.getEncoded());
                break;
            }
            case EC_SECP256K1: {
                pair = VirgilKeyPair.ecKoblitz256(password.getEncoded());
                break;
            }
            case EC_SECP192R1: {
                pair = VirgilKeyPair.ecNist192(password.getEncoded());
                break;
            }
            case EC_SECP224R1: {
                pair = VirgilKeyPair.ecNist224(password.getEncoded());
                break;
            }
            case EC_SECP256R1: {
                pair = VirgilKeyPair.ecNist256(password.getEncoded());
                break;
            }
            case EC_SECP384R1: {
                pair = VirgilKeyPair.ecNist384(password.getEncoded());
                break;
            }
            case EC_SECP521R1: {
                pair = VirgilKeyPair.ecNist521(password.getEncoded());
                break;
            }
            case RSA_256: {
                pair = VirgilKeyPair.rsa256(password.getEncoded());
                break;
            }
            case RSA_512: {
                pair = VirgilKeyPair.rsa512(password.getEncoded());
                break;
            }
            case RSA_1024: {
                pair = VirgilKeyPair.rsa1024(password.getEncoded());
                break;
            }
            case RSA_2048: {
                pair = VirgilKeyPair.rsa2048(password.getEncoded());
                break;
            }
            case RSA_4096: {
                pair = VirgilKeyPair.rsa4096(password.getEncoded());
                break;
            }
            default: {
                throw new IllegalArgumentException("Key type " + (Object)((Object)keyType) + " is not supported");
            }
        }
        return new KeyPair(pair);
    }

    public static KeyPair generate(KeyType keyType, String password) {
        return KeyPairGenerator.generate(keyType, new Password(password));
    }
}

