/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.crypto;

import com.virgilsecurity.sdk.crypto.Base64;
import com.virgilsecurity.sdk.crypto.Cipher;
import com.virgilsecurity.sdk.crypto.Password;
import com.virgilsecurity.sdk.crypto.PrivateKey;
import com.virgilsecurity.sdk.crypto.PublicKey;
import com.virgilsecurity.sdk.crypto.Recipient;
import com.virgilsecurity.sdk.crypto.Signer;
import com.virgilsecurity.sdk.crypto.StreamCipher;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class CryptoHelper {
    public static String encrypt(String text, String password) throws Exception {
        try (Cipher cipher = new Cipher();){
            cipher.addPasswordRecipient(new Password(password));
            byte[] encrypted = cipher.encrypt(text.getBytes(), true);
            String string = Base64.encode(encrypted);
            return string;
        }
    }

    public static void encrypt(InputStream inputStream, OutputStream outputStream, String password) throws Exception {
        try (StreamCipher cipher = new StreamCipher();){
            cipher.addPasswordRecipient(password);
            cipher.encrypt(inputStream, outputStream);
        }
    }

    public static String encrypt(String text, String recipientId, PublicKey publicKey) throws Exception {
        try (Cipher cipher = new Cipher();){
            cipher.addKeyRecipient(new Recipient(recipientId), publicKey);
            byte[] encrypted = cipher.encrypt(text.getBytes(), true);
            String string = Base64.encode(encrypted);
            return string;
        }
    }

    public static void encrypt(InputStream inputStream, OutputStream outputStream, String recipientId, PublicKey publicKey) throws Exception {
        try (StreamCipher cipher = new StreamCipher();){
            cipher.addKeyRecipient(new Recipient(recipientId), publicKey);
            cipher.encrypt(inputStream, outputStream);
        }
    }

    public static String encrypt(String text, Map<String, PublicKey> recipients) throws Exception {
        try (Cipher cipher = new Cipher();){
            for (Map.Entry<String, PublicKey> entry : recipients.entrySet()) {
                cipher.addKeyRecipient(new Recipient(entry.getKey()), entry.getValue());
            }
            byte[] encrypted = cipher.encrypt(text.getBytes(), true);
            String string = Base64.encode(encrypted);
            return string;
        }
    }

    public static String decrypt(String base64Text, String password) throws Exception {
        try (Cipher cipher = new Cipher();){
            cipher.addPasswordRecipient(new Password(password));
            byte[] decrypted = cipher.decryptWithPassword(Base64.decode(base64Text), new Password(password));
            String string = new String(decrypted);
            return string;
        }
    }

    public static void decrypt(InputStream inputStream, OutputStream outputStream, String password) throws Exception {
        try (StreamCipher cipher = new StreamCipher();){
            cipher.decryptWithPassword(inputStream, outputStream, new Password(password));
        }
    }

    public static String decrypt(String base64Text, String recipientId, PrivateKey privateKey) throws Exception {
        try (Cipher cipher = new Cipher();){
            byte[] decrypted = cipher.decryptWithKey(Base64.decode(base64Text), new Recipient(recipientId), privateKey);
            String string = new String(decrypted);
            return string;
        }
    }

    public static void decrypt(InputStream inputStream, OutputStream outputStream, String recipientId, PrivateKey privateKey) throws Exception {
        try (StreamCipher cipher = new StreamCipher();){
            cipher.decryptWithKey(inputStream, outputStream, new Recipient(recipientId), privateKey);
        }
    }

    public static String decrypt(String base64Text, String recipientId, PrivateKey privateKey, Password password) throws Exception {
        try (Cipher cipher = new Cipher();){
            byte[] decrypted = cipher.decryptWithKey(Base64.decode(base64Text), new Recipient(recipientId), privateKey, password);
            String string = new String(decrypted);
            return string;
        }
    }

    public static void decrypt(InputStream inputStream, OutputStream outputStream, String recipientId, PrivateKey privateKey, Password password) throws Exception {
        try (StreamCipher cipher = new StreamCipher();){
            cipher.decryptWithKey(inputStream, outputStream, new Recipient(recipientId), privateKey, password);
        }
    }

    public static String sign(String text, PrivateKey privateKey) throws Exception {
        try (Signer signer = new Signer();){
            byte[] signature = signer.sign(text.getBytes(), privateKey);
            String string = Base64.encode(signature);
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    public static String sign(InputStream inputStream, PrivateKey privateKey) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String sign(InputStream inputStream, PrivateKey privateKey, String keyPassword) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String signBase64(String base64string, PrivateKey privateKey) throws Exception {
        try (Signer signer = new Signer();){
            byte[] signature = signer.sign(Base64.decode(base64string), privateKey);
            String string = Base64.encode(signature);
            return string;
        }
    }

    public static String sign(String text, PrivateKey privateKey, Password password) throws Exception {
        try (Signer signer = new Signer();){
            byte[] signature = signer.sign(text.getBytes(), privateKey, password);
            String string = Base64.encode(signature);
            return string;
        }
    }

    public static boolean verify(String text, String signature, PublicKey publicKey) throws Exception {
        try (Signer signer = new Signer();){
            boolean bl = signer.verify(text.getBytes(), Base64.decode(signature), publicKey);
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean verify(InputStream inputStream, String signature, PublicKey publicKey) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean verifyBase64(String base64string, String signature, PublicKey publicKey) throws Exception {
        try (Signer signer = new Signer();){
            boolean bl = signer.verify(Base64.decode(base64string), Base64.decode(signature), publicKey);
            return bl;
        }
    }
}

