/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.crypto;

import com.virgilsecurity.crypto.VirgilCipherBase;
import com.virgilsecurity.sdk.crypto.CustomParams;
import com.virgilsecurity.sdk.crypto.Password;
import com.virgilsecurity.sdk.crypto.PublicKey;
import com.virgilsecurity.sdk.crypto.Recipient;

public class CipherBase
implements AutoCloseable {
    protected VirgilCipherBase cipher;

    public CipherBase() {
        this.cipher = new VirgilCipherBase();
    }

    protected CipherBase(VirgilCipherBase cipher) {
        this.cipher = cipher;
    }

    public void addKeyRecipient(Recipient recipient, PublicKey publicKey) {
        this.cipher.addKeyRecipient(recipient.getId(), publicKey.getEncoded());
    }

    public void addKeyRecipient(String recipientId, PublicKey publicKey) {
        this.addKeyRecipient(new Recipient(recipientId), publicKey);
    }

    public void removeKeyRecipient(Recipient recipient) {
        this.cipher.removeKeyRecipient(recipient.getId());
    }

    public void addPasswordRecipient(Password password) {
        this.cipher.addPasswordRecipient(password.getEncoded());
    }

    public void addPasswordRecipient(String password) {
        this.cipher.addPasswordRecipient(password.getBytes());
    }

    public void removePasswordRecipient(Password password) {
        this.cipher.removePasswordRecipient(password.getEncoded());
    }

    public void removeAllRecipients() {
        this.cipher.removeAllRecipients();
    }

    public byte[] getContentInfo() {
        return this.cipher.getContentInfo();
    }

    public void setContentInfo(byte[] contentInfo) {
        this.cipher.setContentInfo(contentInfo);
    }

    public static long defineContentInfoSize(byte[] data) {
        return VirgilCipherBase.defineContentInfoSize(data);
    }

    public CustomParams customParams() {
        return new CustomParams(this.cipher.customParams());
    }

    @Override
    public void close() throws Exception {
        this.cipher.close();
    }
}

