/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.http.interceptors;

import com.virgilsecurity.sdk.crypto.CryptoHelper;
import com.virgilsecurity.sdk.crypto.PublicKey;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class RequestBodyEncodeInterceptor
implements Interceptor {
    private static final Logger LOGGER = Logger.getLogger(RequestBodyEncodeInterceptor.class.getName());
    private String recipientId;
    private PublicKey publicKey;

    public RequestBodyEncodeInterceptor(String recipientId, PublicKey publicKey) {
        this.recipientId = recipientId;
        this.publicKey = publicKey;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        try {
            RequestBody body = this.encodeBody(request.body());
            Request.Builder builder = request.newBuilder();
            request = builder.method(request.method(), body).build();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Can't encode request body", e);
        }
        return chain.proceed(request);
    }

    private RequestBody encodeBody(RequestBody originalBody) throws Exception {
        Buffer buffer = new Buffer();
        originalBody.writeTo((BufferedSink)buffer);
        byte[] body = new byte[(int)buffer.size()];
        buffer.read(body);
        String encryptedBody = CryptoHelper.encrypt(new String(body), this.recipientId, this.publicKey);
        RequestBody requestBody = RequestBody.create((MediaType)originalBody.contentType(), (String)encryptedBody);
        return requestBody;
    }
}

