/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client;

import com.virgilsecurity.sdk.client.AbstractClient;
import com.virgilsecurity.sdk.client.exceptions.ServiceException;
import com.virgilsecurity.sdk.client.http.ResponseCallback;
import com.virgilsecurity.sdk.client.http.VoidResponseCallback;
import com.virgilsecurity.sdk.client.http.interceptors.RequestBodyEncodeInterceptor;
import com.virgilsecurity.sdk.client.http.interceptors.RequestSignInterceptor;
import com.virgilsecurity.sdk.client.http.interceptors.ResponseBodyDecodeInterceptor;
import com.virgilsecurity.sdk.client.http.interceptors.TokenInterceptor;
import com.virgilsecurity.sdk.client.model.identity.ValidatedIdentity;
import com.virgilsecurity.sdk.client.model.privatekey.PrivateKeyAPIError;
import com.virgilsecurity.sdk.client.model.privatekey.PrivateKeyInfo;
import com.virgilsecurity.sdk.client.model.privatekey.PrivateKeyRequestPayload;
import com.virgilsecurity.sdk.client.model.publickey.VirgilCard;
import com.virgilsecurity.sdk.client.service.PrivateKeyService;
import com.virgilsecurity.sdk.crypto.Base64;
import com.virgilsecurity.sdk.crypto.Password;
import com.virgilsecurity.sdk.crypto.PrivateKey;
import com.virgilsecurity.sdk.crypto.PublicKey;
import java.io.IOException;
import java.util.UUID;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class PrivateKeyClient
extends AbstractClient {
    public static final String PRIVATE_KEY_BASE_URL = "https://keys-private.virgilsecurity.com";
    private VirgilCard serviceCard;

    public PrivateKeyClient(String accessToken, VirgilCard serviceCard) {
        this(PRIVATE_KEY_BASE_URL, accessToken, serviceCard);
    }

    public PrivateKeyClient(String baseUrl, String accessToken, VirgilCard serviceCard) {
        super(baseUrl, accessToken);
        if (serviceCard == null) {
            throw new IllegalArgumentException("Service Card should be defined.");
        }
        this.serviceCard = serviceCard;
    }

    public <S> S createService(Class<S> serviceClass, PrivateKey privateKey, Password privateKeyPassword, Password responsePassword) {
        OkHttpClient.Builder buider = new OkHttpClient.Builder();
        buider.addInterceptor((Interceptor)new TokenInterceptor(this.accessToken));
        if (privateKey != null) {
            buider.addInterceptor((Interceptor)new RequestSignInterceptor(privateKey, privateKeyPassword));
        }
        buider.addInterceptor((Interceptor)new RequestBodyEncodeInterceptor(this.serviceCard.getId(), new PublicKey(Base64.decode(this.serviceCard.getPublicKey().getKey()))));
        if (responsePassword != null) {
            buider.addInterceptor((Interceptor)new ResponseBodyDecodeInterceptor(responsePassword));
        }
        Retrofit retrofit = this.builder.client(buider.build()).build();
        return (S)retrofit.create(serviceClass);
    }

    @Override
    public Object handleResponse(Response<?> response) throws IOException {
        if (response.isSuccessful()) {
            return response.body();
        }
        PrivateKeyAPIError error = new PrivateKeyAPIError(response.code(), response.errorBody().string());
        throw new ServiceException(error);
    }

    public void stash(String virgilCardId, PrivateKey privateKey) {
        this.stash(virgilCardId, privateKey, (Password)null);
    }

    public void stash(String virgilCardId, PrivateKey privateKey, Password password) {
        try {
            PrivateKeyInfo info = new PrivateKeyInfo();
            info.setCardId(virgilCardId);
            info.setKey(privateKey.getAsBase64String());
            Response response = this.createService(PrivateKeyService.class, privateKey, password, null).stash(info).execute();
            this.handleResponse(response);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public void stash(String virgilCardId, PrivateKey privateKey, VoidResponseCallback callback) {
        this.stash(virgilCardId, privateKey, null, callback);
    }

    public void stash(String virgilCardId, PrivateKey privateKey, Password password, VoidResponseCallback callback) {
        PrivateKeyInfo info = new PrivateKeyInfo();
        info.setCardId(virgilCardId);
        info.setKey(privateKey.getAsBase64String());
        this.createService(PrivateKeyService.class, privateKey, password, null).stash(info).enqueue((Callback)callback);
    }

    public PrivateKeyInfo get(String virgilCardId, ValidatedIdentity identity) {
        try {
            String responsePassword = UUID.randomUUID().toString().replaceAll("-", "").substring(0, 31);
            PrivateKeyRequestPayload payload = new PrivateKeyRequestPayload();
            payload.setCardId(virgilCardId);
            payload.setIdentity(identity);
            payload.setResponsePassword(responsePassword);
            Response response = this.createService(PrivateKeyService.class, null, null, new Password(responsePassword)).get(payload).execute();
            return (PrivateKeyInfo)this.handleResponse(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(e);
        }
    }

    public void get(String virgilCardId, ValidatedIdentity identity, ResponseCallback<PrivateKeyInfo> callback) {
        String responsePassword = UUID.randomUUID().toString().replaceAll("-", "");
        PrivateKeyRequestPayload payload = new PrivateKeyRequestPayload();
        payload.setCardId(virgilCardId);
        payload.setIdentity(identity);
        payload.setResponsePassword(responsePassword);
        this.createService(PrivateKeyService.class, null, null, new Password(responsePassword)).get(payload).enqueue(callback);
    }

    public void destroy(String virgilCardId, PrivateKey privateKey) {
        this.destroy(virgilCardId, privateKey, (Password)null);
    }

    public void destroy(String virgilCardId, PrivateKey privateKey, Password password) {
        try {
            PrivateKeyInfo info = new PrivateKeyInfo();
            info.setCardId(virgilCardId);
            Response response = this.createService(PrivateKeyService.class, privateKey, password, null).destroy(info).execute();
            this.handleResponse(response);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public void destroy(String virgilCardId, PrivateKey privateKey, VoidResponseCallback callback) {
        this.destroy(virgilCardId, privateKey, null, callback);
    }

    public void destroy(String virgilCardId, PrivateKey privateKey, Password password, VoidResponseCallback callback) {
        PrivateKeyInfo info = new PrivateKeyInfo();
        info.setCardId(virgilCardId);
        this.createService(PrivateKeyService.class, privateKey, password, null).destroy(info).enqueue((Callback)callback);
    }
}

