/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.crypto;

import com.virgilsecurity.crypto.VirgilHash;
import com.virgilsecurity.crypto.VirgilSigner;
import com.virgilsecurity.sdk.crypto.Password;
import com.virgilsecurity.sdk.crypto.PrivateKey;
import com.virgilsecurity.sdk.crypto.PublicKey;

public class Signer
implements AutoCloseable {
    private final VirgilSigner signer;

    public Signer() {
        this.signer = new VirgilSigner();
    }

    public Signer(VirgilHash hash) {
        this.signer = new VirgilSigner(hash);
    }

    public byte[] sign(byte[] data, PrivateKey privateKey) {
        return this.signer.sign(data, privateKey.getEncoded());
    }

    public byte[] sign(byte[] data, PrivateKey privateKey, Password privateKeyPassword) {
        return this.signer.sign(data, privateKey.getEncoded(), privateKeyPassword.getEncoded());
    }

    public boolean verify(byte[] data, byte[] sign, PublicKey publicKey) {
        return this.signer.verify(data, sign, publicKey.getEncoded());
    }

    @Override
    public void close() throws Exception {
        if (this.signer != null) {
            this.signer.close();
        }
    }
}

