/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.http.interceptors;

import com.virgilsecurity.sdk.crypto.CryptoHelper;
import com.virgilsecurity.sdk.crypto.Password;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ResponseBodyDecodeInterceptor
implements Interceptor {
    private static final Logger LOGGER = Logger.getLogger(ResponseBodyDecodeInterceptor.class.getName());
    private Password password;

    public ResponseBodyDecodeInterceptor(Password password) {
        this.password = password;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        if (response.code() < 400) {
            try {
                ResponseBody body = this.decodeBody(response.body());
                Response.Builder builder = response.newBuilder();
                response = builder.body(body).build();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Can't encode request body", e);
            }
        }
        return response;
    }

    private ResponseBody decodeBody(ResponseBody encodedBody) throws Exception {
        String text = CryptoHelper.decrypt(encodedBody.string(), this.password.toString());
        ResponseBody responseBody = ResponseBody.create((MediaType)encodedBody.contentType(), (String)text);
        return responseBody;
    }
}

