/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client;

import com.virgilsecurity.sdk.client.AbstractClient;
import com.virgilsecurity.sdk.client.exceptions.ServiceException;
import com.virgilsecurity.sdk.client.http.ResponseCallback;
import com.virgilsecurity.sdk.client.http.VoidResponseCallback;
import com.virgilsecurity.sdk.client.model.APIError;
import com.virgilsecurity.sdk.client.model.Identity;
import com.virgilsecurity.sdk.client.model.IdentityType;
import com.virgilsecurity.sdk.client.model.identity.Action;
import com.virgilsecurity.sdk.client.model.identity.Confirmation;
import com.virgilsecurity.sdk.client.model.identity.ValidatedIdentity;
import com.virgilsecurity.sdk.client.service.IdentityService;
import java.io.IOException;
import retrofit2.Callback;
import retrofit2.Response;

public class IdentityClient
extends AbstractClient {
    public static final String IDENTITY_BASE_URL = "https://identity.virgilsecurity.com";

    public IdentityClient() {
        this(IDENTITY_BASE_URL);
    }

    public IdentityClient(String baseUrl) {
        super(baseUrl, null);
    }

    public String verify(IdentityType type, String value) {
        try {
            Response response = this.createService(IdentityService.class).verify(new Identity(type, value)).execute();
            return ((Action)this.handleResponse(response)).getActionId();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public void verify(IdentityType type, String value, ResponseCallback<Action> callback) throws IOException {
        this.createService(IdentityService.class).verify(new Identity(type, value)).enqueue(callback);
    }

    public ValidatedIdentity confirm(String actionId, String confirmationCode) {
        Confirmation confirmation = new Confirmation();
        confirmation.setActionId(actionId);
        confirmation.setConfirmationCode(confirmationCode);
        try {
            Response response = this.createService(IdentityService.class).confirm(confirmation).execute();
            return (ValidatedIdentity)this.handleResponse(response);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public void confirm(String actionId, String confirmationCode, ResponseCallback<ValidatedIdentity> callback) throws IOException {
        Confirmation confirmation = new Confirmation();
        confirmation.setActionId(actionId);
        confirmation.setConfirmationCode(confirmationCode);
        this.createService(IdentityService.class).confirm(confirmation).enqueue(callback);
    }

    public boolean validate(ValidatedIdentity identity) {
        try {
            Response response = this.createService(IdentityService.class).validate(identity).execute();
            if (response.code() < 400) {
                return true;
            }
            if (response.code() == 400) {
                return false;
            }
            APIError error = new APIError(response.code(), response.errorBody().string());
            throw new ServiceException(error);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public void validate(ValidatedIdentity identity, VoidResponseCallback callback) throws IOException {
        this.createService(IdentityService.class).validate(identity).enqueue((Callback)callback);
    }
}

