/*
 * Decompiled with CFR 0.152.
 */
package com.vipulasri.ticketview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.vipulasri.ticketview.BlurBuilder;
import com.vipulasri.ticketview.R;
import com.vipulasri.ticketview.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TicketView
extends View {
    public static final String TAG = TicketView.class.getSimpleName();
    private Paint mBackgroundPaint = new Paint();
    private Paint mBorderPaint = new Paint();
    private Paint mDividerPaint = new Paint();
    private int mOrientation;
    private Path mPath = new Path();
    private boolean mDirty = true;
    private float mDividerStartX;
    private float mDividerStartY;
    private float mDividerStopX;
    private float mDividerStopY;
    private RectF mRect = new RectF();
    private RectF mRoundedCornerArc = new RectF();
    private RectF mScallopCornerArc = new RectF();
    private int mScallopHeight;
    private float mScallopPosition;
    private float mScallopPositionPercent;
    private int mBackgroundColor;
    private boolean mShowBorder;
    private int mBorderWidth;
    private int mBorderColor;
    private boolean mShowDivider;
    private int mScallopRadius;
    private int mDividerDashLength;
    private int mDividerDashGap;
    private int mDividerType;
    private int mDividerWidth;
    private int mDividerColor;
    private int mCornerType;
    private int mCornerRadius;
    private int mDividerPadding;
    private Bitmap mShadow;
    private final Paint mShadowPaint = new Paint(1);
    private int mShadowColor;
    private float mShadowBlurRadius = 0.0f;
    private Drawable mBackgroundBeforeDivider;
    private Drawable mBackgroundAfterDivider;

    public TicketView(Context context) {
        super(context);
        this.init(null);
    }

    public TicketView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public TicketView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDirty) {
            this.doLayout();
        }
        if (this.mShadowBlurRadius > 0.0f && !this.isInEditMode()) {
            canvas.drawBitmap(this.mShadow, 0.0f, this.mShadowBlurRadius / 2.0f, null);
        }
        canvas.drawPath(this.mPath, this.mBackgroundPaint);
        canvas.clipPath(this.mPath);
        if (this.mShowBorder) {
            canvas.drawPath(this.mPath, this.mBorderPaint);
        }
        if (this.mShowDivider) {
            canvas.drawLine(this.mDividerStartX, this.mDividerStartY, this.mDividerStopX, this.mDividerStopY, this.mDividerPaint);
        }
        if (this.mBackgroundAfterDivider != null) {
            this.setTicketBackgroundAfterDivider(canvas);
        }
        if (this.mBackgroundBeforeDivider != null) {
            this.setTicketBackgroundBeforeDivider(canvas);
        }
    }

    private void doLayout() {
        float offset;
        float left = (float)this.getPaddingLeft() + this.mShadowBlurRadius;
        float right = (float)(this.getWidth() - this.getPaddingRight()) - this.mShadowBlurRadius;
        float top = (float)this.getPaddingTop() + this.mShadowBlurRadius / 2.0f;
        float bottom = (float)(this.getHeight() - this.getPaddingBottom()) - this.mShadowBlurRadius - this.mShadowBlurRadius / 2.0f;
        this.mPath.reset();
        if (this.mOrientation == 0) {
            offset = (top + bottom) / this.mScallopPosition - (float)this.mScallopRadius;
            if (this.mCornerType == 1) {
                this.mPath.arcTo(this.getTopLeftCornerRoundedArc(top, left), 180.0f, 90.0f, false);
                this.mPath.lineTo(left + (float)this.mCornerRadius, top);
                this.mPath.lineTo(right - (float)this.mCornerRadius, top);
                this.mPath.arcTo(this.getTopRightCornerRoundedArc(top, right), -90.0f, 90.0f, false);
            } else if (this.mCornerType == 2) {
                this.mPath.arcTo(this.getTopLeftCornerScallopArc(top, left), 90.0f, -90.0f, false);
                this.mPath.lineTo(left + (float)this.mCornerRadius, top);
                this.mPath.lineTo(right - (float)this.mCornerRadius, top);
                this.mPath.arcTo(this.getTopRightCornerScallopArc(top, right), 180.0f, -90.0f, false);
            } else {
                this.mPath.moveTo(left, top);
                this.mPath.lineTo(right, top);
            }
            this.mRect.set(right - (float)this.mScallopRadius, top + offset, right + (float)this.mScallopRadius, (float)this.mScallopHeight + offset + top);
            this.mPath.arcTo(this.mRect, 270.0f, -180.0f, false);
            if (this.mCornerType == 1) {
                this.mPath.arcTo(this.getBottomRightCornerRoundedArc(bottom, right), 0.0f, 90.0f, false);
                this.mPath.lineTo(right - (float)this.mCornerRadius, bottom);
                this.mPath.lineTo(left + (float)this.mCornerRadius, bottom);
                this.mPath.arcTo(this.getBottomLeftCornerRoundedArc(left, bottom), 90.0f, 90.0f, false);
            } else if (this.mCornerType == 2) {
                this.mPath.arcTo(this.getBottomRightCornerScallopArc(bottom, right), 270.0f, -90.0f, false);
                this.mPath.lineTo(right - (float)this.mCornerRadius, bottom);
                this.mPath.lineTo(left + (float)this.mCornerRadius, bottom);
                this.mPath.arcTo(this.getBottomLeftCornerScallopArc(left, bottom), 0.0f, -90.0f, false);
            } else {
                this.mPath.lineTo(right, bottom);
                this.mPath.lineTo(left, bottom);
            }
            this.mRect.set(left - (float)this.mScallopRadius, top + offset, left + (float)this.mScallopRadius, (float)this.mScallopHeight + offset + top);
            this.mPath.arcTo(this.mRect, 90.0f, -180.0f, false);
            this.mPath.close();
        } else {
            offset = (right + left) / this.mScallopPosition - (float)this.mScallopRadius;
            if (this.mCornerType == 1) {
                this.mPath.arcTo(this.getTopLeftCornerRoundedArc(top, left), 180.0f, 90.0f, false);
                this.mPath.lineTo(left + (float)this.mCornerRadius, top);
            } else if (this.mCornerType == 2) {
                this.mPath.arcTo(this.getTopLeftCornerScallopArc(top, left), 90.0f, -90.0f, false);
                this.mPath.lineTo(left + (float)this.mCornerRadius, top);
            } else {
                this.mPath.moveTo(left, top);
            }
            this.mRect.set(left + offset, top - (float)this.mScallopRadius, (float)this.mScallopHeight + offset + left, top + (float)this.mScallopRadius);
            this.mPath.arcTo(this.mRect, 180.0f, -180.0f, false);
            if (this.mCornerType == 1) {
                this.mPath.lineTo(right - (float)this.mCornerRadius, top);
                this.mPath.arcTo(this.getTopRightCornerRoundedArc(top, right), -90.0f, 90.0f, false);
                this.mPath.arcTo(this.getBottomRightCornerRoundedArc(bottom, right), 0.0f, 90.0f, false);
                this.mPath.lineTo(right - (float)this.mCornerRadius, bottom);
            } else if (this.mCornerType == 2) {
                this.mPath.lineTo(right - (float)this.mCornerRadius, top);
                this.mPath.arcTo(this.getTopRightCornerScallopArc(top, right), 180.0f, -90.0f, false);
                this.mPath.arcTo(this.getBottomRightCornerScallopArc(bottom, right), 270.0f, -90.0f, false);
                this.mPath.lineTo(right - (float)this.mCornerRadius, bottom);
            } else {
                this.mPath.lineTo(right, top);
                this.mPath.lineTo(right, bottom);
            }
            this.mRect.set(left + offset, bottom - (float)this.mScallopRadius, (float)this.mScallopHeight + offset + left, bottom + (float)this.mScallopRadius);
            this.mPath.arcTo(this.mRect, 0.0f, -180.0f, false);
            if (this.mCornerType == 1) {
                this.mPath.arcTo(this.getBottomLeftCornerRoundedArc(left, bottom), 90.0f, 90.0f, false);
                this.mPath.lineTo(left, bottom - (float)this.mCornerRadius);
            } else if (this.mCornerType == 2) {
                this.mPath.arcTo(this.getBottomLeftCornerScallopArc(left, bottom), 0.0f, -90.0f, false);
                this.mPath.lineTo(left, bottom - (float)this.mCornerRadius);
            } else {
                this.mPath.lineTo(left, bottom);
            }
            this.mPath.close();
        }
        if (this.mOrientation == 0) {
            this.mDividerStartX = left + (float)this.mScallopRadius + (float)this.mDividerPadding;
            this.mDividerStartY = (float)this.mScallopRadius + top + offset;
            this.mDividerStopX = right - (float)this.mScallopRadius - (float)this.mDividerPadding;
            this.mDividerStopY = (float)this.mScallopRadius + top + offset;
        } else {
            this.mDividerStartX = (float)this.mScallopRadius + left + offset;
            this.mDividerStartY = top + (float)this.mScallopRadius + (float)this.mDividerPadding;
            this.mDividerStopX = (float)this.mScallopRadius + left + offset;
            this.mDividerStopY = bottom - (float)this.mScallopRadius - (float)this.mDividerPadding;
        }
        this.generateShadow();
        this.mDirty = false;
    }

    private void generateShadow() {
        if (Utils.isJellyBeanAndAbove() && !this.isInEditMode()) {
            if (this.mShadowBlurRadius == 0.0f) {
                return;
            }
            if (this.mShadow == null) {
                this.mShadow = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            } else {
                this.mShadow.eraseColor(0);
            }
            Canvas canvas = new Canvas(this.mShadow);
            canvas.drawPath(this.mPath, this.mShadowPaint);
            if (this.mShowBorder) {
                canvas.drawPath(this.mPath, this.mShadowPaint);
            }
            this.mShadow = BlurBuilder.blur(this.getContext(), this.mShadow, this.mShadowBlurRadius);
        }
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.TicketView);
            this.mBackgroundBeforeDivider = typedArray.getDrawable(R.styleable.TicketView_ticketBackgroundBeforeDivider);
            this.mBackgroundAfterDivider = typedArray.getDrawable(R.styleable.TicketView_ticketBackgroundAfterDivider);
            this.mOrientation = typedArray.getInt(R.styleable.TicketView_ticketOrientation, 0);
            this.mBackgroundColor = typedArray.getColor(R.styleable.TicketView_ticketBackgroundColor, this.getResources().getColor(17170443));
            this.mScallopRadius = typedArray.getDimensionPixelSize(R.styleable.TicketView_ticketScallopRadius, Utils.dpToPx(20.0f, this.getContext()));
            this.mScallopPositionPercent = typedArray.getFloat(R.styleable.TicketView_ticketScallopPositionPercent, 50.0f);
            this.mShowBorder = typedArray.getBoolean(R.styleable.TicketView_ticketShowBorder, false);
            this.mBorderWidth = typedArray.getDimensionPixelSize(R.styleable.TicketView_ticketBorderWidth, Utils.dpToPx(2.0f, this.getContext()));
            this.mBorderColor = typedArray.getColor(R.styleable.TicketView_ticketBorderColor, this.getResources().getColor(17170444));
            this.mShowDivider = typedArray.getBoolean(R.styleable.TicketView_ticketShowDivider, false);
            this.mDividerType = typedArray.getInt(R.styleable.TicketView_ticketDividerType, 0);
            this.mDividerWidth = typedArray.getDimensionPixelSize(R.styleable.TicketView_ticketDividerWidth, Utils.dpToPx(2.0f, this.getContext()));
            this.mDividerColor = typedArray.getColor(R.styleable.TicketView_ticketDividerColor, this.getResources().getColor(0x1060000));
            this.mDividerDashLength = typedArray.getDimensionPixelSize(R.styleable.TicketView_ticketDividerDashLength, Utils.dpToPx(8.0f, this.getContext()));
            this.mDividerDashGap = typedArray.getDimensionPixelSize(R.styleable.TicketView_ticketDividerDashGap, Utils.dpToPx(4.0f, this.getContext()));
            this.mCornerType = typedArray.getInt(R.styleable.TicketView_ticketCornerType, 0);
            this.mCornerRadius = typedArray.getDimensionPixelSize(R.styleable.TicketView_ticketCornerRadius, Utils.dpToPx(4.0f, this.getContext()));
            this.mDividerPadding = typedArray.getDimensionPixelSize(R.styleable.TicketView_ticketDividerPadding, Utils.dpToPx(10.0f, this.getContext()));
            float elevation = 0.0f;
            if (typedArray.hasValue(R.styleable.TicketView_ticketElevation)) {
                elevation = typedArray.getDimension(R.styleable.TicketView_ticketElevation, elevation);
            } else if (typedArray.hasValue(R.styleable.TicketView_android_elevation)) {
                elevation = typedArray.getDimension(R.styleable.TicketView_android_elevation, elevation);
            }
            if (elevation > 0.0f) {
                this.setShadowBlurRadius(elevation);
            }
            this.mShadowColor = typedArray.getColor(R.styleable.TicketView_ticketShadowColor, this.getResources().getColor(17170444));
            typedArray.recycle();
        }
        this.initElements();
        this.setLayerType(1, null);
    }

    private void initElements() {
        if (this.mDividerWidth > this.mScallopRadius) {
            this.mDividerWidth = this.mScallopRadius;
            Log.w((String)TAG, (String)"You cannot apply divider width greater than scallop radius. Applying divider width to scallop radius.");
        }
        this.mScallopPosition = 100.0f / this.mScallopPositionPercent;
        this.mScallopHeight = this.mScallopRadius * 2;
        this.setShadowPaint();
        this.setBackgroundPaint();
        this.setBorderPaint();
        this.setDividerPaint();
        this.mDirty = true;
        this.invalidate();
    }

    private void setTicketBackgroundBeforeDivider(Canvas canvas) {
        float left = (float)this.getPaddingLeft() + this.mShadowBlurRadius;
        float right = (float)(this.getWidth() - this.getPaddingRight()) - this.mShadowBlurRadius;
        float top = (float)this.getPaddingTop() + this.mShadowBlurRadius / 2.0f;
        float bottom = (float)(this.getHeight() - this.getPaddingBottom()) - this.mShadowBlurRadius - this.mShadowBlurRadius / 2.0f;
        if (this.mOrientation == 0) {
            this.mBackgroundBeforeDivider.setBounds((int)left, (int)top, (int)right, (int)this.mDividerStartY);
        } else {
            this.mBackgroundBeforeDivider.setBounds((int)left, (int)top, (int)this.mDividerStartX, (int)bottom);
        }
        this.mBackgroundBeforeDivider.draw(canvas);
    }

    private void setTicketBackgroundAfterDivider(Canvas canvas) {
        float left = (float)this.getPaddingLeft() + this.mShadowBlurRadius;
        float right = (float)(this.getWidth() - this.getPaddingRight()) - this.mShadowBlurRadius;
        float top = (float)this.getPaddingTop() + this.mShadowBlurRadius / 2.0f;
        float bottom = (float)(this.getHeight() - this.getPaddingBottom()) - this.mShadowBlurRadius - this.mShadowBlurRadius / 2.0f;
        if (this.mOrientation == 0) {
            this.mBackgroundAfterDivider.setBounds((int)left, (int)this.mDividerStopY, (int)right, (int)bottom);
        } else {
            this.mBackgroundAfterDivider.setBounds((int)this.mDividerStopX, (int)top, (int)right, (int)bottom);
        }
        this.mBackgroundAfterDivider.draw(canvas);
    }

    private void setShadowPaint() {
        this.mShadowPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.mShadowColor, PorterDuff.Mode.SRC_IN));
        this.mShadowPaint.setAlpha(51);
    }

    private void setBackgroundPaint() {
        this.mBackgroundPaint.setAlpha(0);
        this.mBackgroundPaint.setAntiAlias(true);
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        this.mBackgroundPaint.setStyle(Paint.Style.FILL);
    }

    private void setBorderPaint() {
        this.mBorderPaint.setAlpha(0);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
    }

    private void setDividerPaint() {
        this.mDividerPaint.setAlpha(0);
        this.mDividerPaint.setAntiAlias(true);
        this.mDividerPaint.setColor(this.mDividerColor);
        this.mDividerPaint.setStrokeWidth((float)this.mDividerWidth);
        if (this.mDividerType == 1) {
            this.mDividerPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{this.mDividerDashLength, this.mDividerDashGap}, 0.0f));
        } else {
            this.mDividerPaint.setPathEffect(new PathEffect());
        }
    }

    private RectF getTopLeftCornerRoundedArc(float top, float left) {
        this.mRoundedCornerArc.set(left, top, left + (float)(this.mCornerRadius * 2), top + (float)(this.mCornerRadius * 2));
        return this.mRoundedCornerArc;
    }

    private RectF getTopRightCornerRoundedArc(float top, float right) {
        this.mRoundedCornerArc.set(right - (float)(this.mCornerRadius * 2), top, right, top + (float)(this.mCornerRadius * 2));
        return this.mRoundedCornerArc;
    }

    private RectF getBottomLeftCornerRoundedArc(float left, float bottom) {
        this.mRoundedCornerArc.set(left, bottom - (float)(this.mCornerRadius * 2), left + (float)(this.mCornerRadius * 2), bottom);
        return this.mRoundedCornerArc;
    }

    private RectF getBottomRightCornerRoundedArc(float bottom, float right) {
        this.mRoundedCornerArc.set(right - (float)(this.mCornerRadius * 2), bottom - (float)(this.mCornerRadius * 2), right, bottom);
        return this.mRoundedCornerArc;
    }

    private RectF getTopLeftCornerScallopArc(float top, float left) {
        this.mScallopCornerArc.set(left - (float)this.mCornerRadius, top - (float)this.mCornerRadius, left + (float)this.mCornerRadius, top + (float)this.mCornerRadius);
        return this.mScallopCornerArc;
    }

    private RectF getTopRightCornerScallopArc(float top, float right) {
        this.mScallopCornerArc.set(right - (float)this.mCornerRadius, top - (float)this.mCornerRadius, right + (float)this.mCornerRadius, top + (float)this.mCornerRadius);
        return this.mScallopCornerArc;
    }

    private RectF getBottomLeftCornerScallopArc(float left, float bottom) {
        this.mScallopCornerArc.set(left - (float)this.mCornerRadius, bottom - (float)this.mCornerRadius, left + (float)this.mCornerRadius, bottom + (float)this.mCornerRadius);
        return this.mScallopCornerArc;
    }

    private RectF getBottomRightCornerScallopArc(float bottom, float right) {
        this.mScallopCornerArc.set(right - (float)this.mCornerRadius, bottom - (float)this.mCornerRadius, right + (float)this.mCornerRadius, bottom + (float)this.mCornerRadius);
        return this.mScallopCornerArc;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
        this.initElements();
    }

    public float getScallopPositionPercent() {
        return this.mScallopPositionPercent;
    }

    public void setScallopPositionPercent(float scallopPositionPercent) {
        this.mScallopPositionPercent = scallopPositionPercent;
        this.initElements();
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
        this.initElements();
    }

    public boolean isShowBorder() {
        return this.mShowBorder;
    }

    public void setShowBorder(boolean showBorder) {
        this.mShowBorder = showBorder;
        this.initElements();
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.mBorderWidth = borderWidth;
        this.initElements();
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
        this.initElements();
    }

    public boolean isShowDivider() {
        return this.mShowDivider;
    }

    public void setShowDivider(boolean showDivider) {
        this.mShowDivider = showDivider;
        this.initElements();
    }

    public int getScallopRadius() {
        return this.mScallopRadius;
    }

    public void setScallopRadius(int scallopRadius) {
        this.mScallopRadius = scallopRadius;
        this.initElements();
    }

    public int getDividerDashLength() {
        return this.mDividerDashLength;
    }

    public void setDividerDashLength(int dividerDashLength) {
        this.mDividerDashLength = dividerDashLength;
        this.initElements();
    }

    public int getDividerDashGap() {
        return this.mDividerDashGap;
    }

    public void setDividerDashGap(int dividerDashGap) {
        this.mDividerDashGap = dividerDashGap;
        this.initElements();
    }

    public int getDividerType() {
        return this.mDividerType;
    }

    public void setDividerType(int dividerType) {
        this.mDividerType = dividerType;
        this.initElements();
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    public void setDividerWidth(int dividerWidth) {
        this.mDividerWidth = dividerWidth;
        this.initElements();
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public void setDividerPadding(int mDividerPadding) {
        this.mDividerPadding = mDividerPadding;
        this.initElements();
    }

    public int getDividerColor() {
        return this.mDividerColor;
    }

    public void setDividerColor(int dividerColor) {
        this.mDividerColor = dividerColor;
        this.initElements();
    }

    public int getCornerType() {
        return this.mCornerType;
    }

    public void setCornerType(int cornerType) {
        this.mCornerType = cornerType;
        this.initElements();
    }

    public int getCornerRadius() {
        return this.mCornerRadius;
    }

    public void setCornerRadius(int cornerRadius) {
        this.mCornerRadius = cornerRadius;
        this.initElements();
    }

    public void setTicketElevation(float elevation) {
        if (!Utils.isJellyBeanAndAbove()) {
            Log.w((String)TAG, (String)"Ticket elevation only works with Android Jelly Bean and above");
            return;
        }
        this.setShadowBlurRadius(elevation);
        this.initElements();
    }

    private void setShadowBlurRadius(float elevation) {
        if (!Utils.isJellyBeanAndAbove()) {
            Log.w((String)TAG, (String)"Ticket elevation only works with Android Jelly Bean and above");
            return;
        }
        float maxElevation = Utils.dpToPx(24.0f, this.getContext());
        this.mShadowBlurRadius = Math.min(25.0f * (elevation / maxElevation), 25.0f);
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public void setShadowColor(int color2) {
        this.mShadowColor = color2;
        this.initElements();
    }

    public Drawable getBackgroundBeforeDivider() {
        return this.mBackgroundBeforeDivider;
    }

    public void setBackgroundBeforeDivider(Drawable background) {
        this.mBackgroundBeforeDivider = background;
        this.initElements();
    }

    public Drawable getBackgroundAfterDivider() {
        return this.mBackgroundAfterDivider;
    }

    public void setBackgroundAfterDivider(Drawable background) {
        this.mBackgroundAfterDivider = background;
        this.initElements();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CornerType {
        public static final int NORMAL = 0;
        public static final int ROUNDED = 1;
        public static final int SCALLOP = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DividerType {
        public static final int NORMAL = 0;
        public static final int DASH = 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
        public static final int HORIZONTAL = 0;
        public static final int VERTICAL = 1;
    }
}

