/*
 * Decompiled with CFR 0.152.
 */
package com.vincent.blurdialog.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;

public class IndeterminateProgressView
extends View {
    private int mViewHeight;
    private int mViewWidth;
    private int mCenterX;
    private int mCenterY;
    private float mStrokeWidth = 2.0f;
    private Paint mProgressPaint;
    private RotateAnimation mRotate;

    public IndeterminateProgressView(Context context) {
        this(context, null);
    }

    public IndeterminateProgressView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IndeterminateProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public IndeterminateProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init() {
        this.mProgressPaint = new Paint();
        this.mProgressPaint.setShader((Shader)new SweepGradient((float)this.mCenterX, (float)this.mCenterY, Color.parseColor((String)"#00000000"), Color.parseColor((String)"#FF47494D")));
        this.mProgressPaint.setAntiAlias(true);
        this.mProgressPaint.setDither(true);
        this.mProgressPaint.setFilterBitmap(true);
        this.mProgressPaint.setStrokeWidth(this.mStrokeWidth);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.mProgressPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mRotate = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        this.mRotate.setInterpolator((Interpolator)new LinearInterpolator());
        this.mRotate.setDuration(1500L);
        this.mRotate.setRepeatCount(-1);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                IndeterminateProgressView.this.startAnimation();
            }
        });
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mViewWidth = w;
        this.mViewHeight = h;
        this.mCenterX = this.mViewWidth / 2;
        this.mCenterY = this.mViewHeight / 2;
        this.init();
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawCircle((float)this.mCenterX, (float)this.mCenterY, (float)this.mCenterX - this.mStrokeWidth, this.mProgressPaint);
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public void setStrokeWidth(float px) {
        this.mStrokeWidth = px;
    }

    public void startAnimation() {
        if (this.mRotate != null) {
            this.startAnimation((Animation)this.mRotate);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        if (0 == visibility) {
            this.startAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        this.mRotate.reset();
        super.onDetachedFromWindow();
    }
}

