/*
 * Decompiled with CFR 0.152.
 */
package com.vincent.blurdialog.helper;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.vincent.blurdialog.R;

public class BlurDialogHelper {
    public static void setBackGroundDrawable(Context ctx, View v, float[] radius) {
        if (Build.VERSION.SDK_INT >= 16) {
            v.setBackground((Drawable)BlurDialogHelper.getClickBgDrawable(ctx, radius));
        } else {
            v.setBackgroundDrawable((Drawable)BlurDialogHelper.getClickBgDrawable(ctx, radius));
        }
    }

    public static StateListDrawable getClickBgDrawable(Context ctx, float[] radius) {
        GradientDrawable selected = new GradientDrawable();
        selected.setColor(ctx.getResources().getColor(R.color.vw_dialog_bg_shadow));
        selected.setCornerRadii(radius);
        ColorDrawable unSelected = new ColorDrawable(0);
        StateListDrawable drawable = new StateListDrawable();
        drawable.addState(new int[]{16842919}, (Drawable)selected);
        drawable.addState(new int[]{-16842919}, (Drawable)unSelected);
        return drawable;
    }

    public static float getRadius(Context ctx, float builderRadius) {
        if (builderRadius >= 0.0f) {
            return TypedValue.applyDimension((int)1, (float)builderRadius, (DisplayMetrics)ctx.getResources().getDisplayMetrics());
        }
        return ctx.getResources().getDimension(R.dimen.vw_dialog_default_radius);
    }
}

