/*
 * Decompiled with CFR 0.152.
 */
package com.vincent.blurdialog.blur;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.vincent.blurdialog.R;
import com.vincent.blurdialog.blur.RealtimeBlurView;

public class RoundRectBlurView
extends RealtimeBlurView {
    private Paint mPaint = new Paint();
    private RectF mRectF;
    private float mXRadius;
    private float mYRadius;
    private Bitmap mRoundBitmap;
    private Canvas mTmpCanvas;

    public RoundRectBlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mPaint.setAntiAlias(true);
        this.mRectF = new RectF();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RoundRectBlurView);
        this.mXRadius = a.getDimension(R.styleable.RoundRectBlurView_xRadius, TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
        this.mYRadius = a.getDimension(R.styleable.RoundRectBlurView_yRadius, TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
        a.recycle();
    }

    @Override
    protected void drawBlurredBitmap(Canvas canvas, Bitmap blurredBitmap, int overlayColor) {
        super.drawBlurredBitmap(canvas, blurredBitmap, overlayColor);
        this.mRectF.right = this.getWidth();
        this.mRectF.bottom = this.getHeight();
        if (this.mRoundBitmap == null) {
            this.mRoundBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        if (this.mTmpCanvas == null) {
            this.mTmpCanvas = new Canvas(this.mRoundBitmap);
        }
        this.mTmpCanvas.drawRoundRect(this.mRectF, this.mXRadius, this.mYRadius, this.mPaint);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        canvas.drawBitmap(this.mRoundBitmap, 0.0f, 0.0f, this.mPaint);
    }

    public void setRadius(float radius) {
        this.mXRadius = radius;
        this.mYRadius = radius;
    }
}

