/*
 * Decompiled with CFR 0.152.
 */
package com.vincent.blurdialog.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.vincent.blurdialog.R;
import com.vincent.blurdialog.helper.BlurDialogHelper;
import com.vincent.blurdialog.listener.OnItemClick;
import java.util.ArrayList;
import java.util.List;

public class SingleSelectAdapter
extends RecyclerView.Adapter<SingleViewHolder> {
    private List<CharSequence> mList;
    private float mRadius;
    private OnItemClick itemClick;

    public SingleSelectAdapter(List<CharSequence> list, float radius, OnItemClick itemClick) {
        this.mList = list == null ? new ArrayList<CharSequence>() : list;
        this.mRadius = radius;
        this.itemClick = itemClick;
    }

    public SingleViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.vw_dialog_single_item, parent, false);
        return new SingleViewHolder(view);
    }

    public void onBindViewHolder(final SingleViewHolder holder, int position) {
        float[] radius;
        Context ctx = holder.itemView.getContext();
        if (position == 0) {
            radius = new float[]{this.mRadius, this.mRadius, this.mRadius, this.mRadius, 0.0f, 0.0f, 0.0f, 0.0f};
            holder.vw_dialog_item_divider.setVisibility(0);
        } else if (position == this.mList.size() - 1) {
            radius = new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.mRadius, this.mRadius, this.mRadius, this.mRadius};
            holder.vw_dialog_item_divider.setVisibility(4);
        } else {
            radius = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            holder.vw_dialog_item_divider.setVisibility(0);
        }
        BlurDialogHelper.setBackGroundDrawable(holder.itemView.getContext(), holder.itemView, radius);
        holder.vw_dialog_tv_item.setText(this.mList.get(position));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SingleSelectAdapter.this.itemClick != null) {
                    SingleSelectAdapter.this.itemClick.onClick((CharSequence)SingleSelectAdapter.this.mList.get(holder.getAdapterPosition()));
                }
            }
        });
    }

    public int getItemCount() {
        return this.mList.size();
    }

    static class SingleViewHolder
    extends RecyclerView.ViewHolder {
        @NonNull
        TextView vw_dialog_tv_item;
        @NonNull
        View vw_dialog_item_divider;

        public SingleViewHolder(View itemView) {
            super(itemView);
            this.vw_dialog_tv_item = (TextView)itemView.findViewById(R.id.vw_dialog_tv_item);
            this.vw_dialog_item_divider = itemView.findViewById(R.id.vw_dialog_item_divider);
        }
    }
}

