/*
 * Decompiled with CFR 0.152.
 */
package com.vincent.blurdialog;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.vincent.blurdialog.R;
import com.vincent.blurdialog.adapter.SingleSelectAdapter;
import com.vincent.blurdialog.blur.RoundRectBlurView;
import com.vincent.blurdialog.helper.BlurDialogHelper;
import com.vincent.blurdialog.listener.OnItemClick;
import com.vincent.blurdialog.listener.OnNegativeClick;
import com.vincent.blurdialog.listener.OnPositiveClick;
import com.vincent.blurdialog.view.DeterminateProgressView;
import com.vincent.blurdialog.view.IndeterminateProgressView;
import java.util.List;

public class BlurDialog {
    public static final int TYPE_DOUBLE_OPTION = 0;
    public static final int TYPE_SINGLE_OPTION = 1;
    public static final int TYPE_NONE_OPTION = 2;
    public static final int TYPE_DELETE = 3;
    public static final int TYPE_WAIT = 4;
    public static final int TYPE_PROGRESS = 5;
    public static final int TYPE_SINGLE_SELECT = 6;
    private int mWindowPaddingStart = 70;
    private int mWindowPaddingEnd = 70;
    private Dialog mDialog;
    private Builder builder;
    private float preProgress = 0.0f;
    private float curProgress = 0.0f;
    private ObjectAnimator mProgressAnimator;

    public BlurDialog() {
    }

    public BlurDialog(Builder builder) {
        this.builder = builder;
    }

    private BlurDialog createDialog(Context ctx) {
        this.mDialog = new Dialog(ctx, 0x1030130);
        this.mDialog.setCanceledOnTouchOutside(this.builder.isOutsideCancelable);
        this.mDialog.setCancelable(this.builder.isCancelable);
        if (this.builder.dismissListener != null) {
            this.mDialog.setOnDismissListener(this.builder.dismissListener);
        }
        switch (this.builder.type) {
            case 0: {
                this.confirmDoubleStyle(this.mDialog);
                break;
            }
            case 1: {
                this.confirmSingleStyle(this.mDialog);
                break;
            }
            case 2: {
                this.confirmNoneStyle(this.mDialog);
                break;
            }
            case 3: {
                this.deleteStyle(this.mDialog);
                break;
            }
            case 4: {
                this.waitStyle(this.mDialog, this.builder);
                break;
            }
            case 5: {
                this.progressStyle(this.mDialog, this.builder);
                break;
            }
            case 6: {
                this.selectSingleStyle(this.mDialog);
            }
        }
        return this;
    }

    private void confirmDoubleStyle(Dialog dialog) {
        dialog.setContentView(R.layout.vw_dialog_option_double);
        TextView vw_dialog_tv_msg = (TextView)dialog.findViewById(R.id.vw_dialog_tv_msg);
        vw_dialog_tv_msg.setText(this.builder.message);
        FrameLayout vw_dialog_fl_center = (FrameLayout)dialog.findViewById(R.id.vw_dialog_fl_center);
        if (this.builder.centerView != null && this.builder.centerViewParams != null) {
            vw_dialog_fl_center.setVisibility(0);
            vw_dialog_fl_center.addView(this.builder.centerView, (ViewGroup.LayoutParams)this.builder.centerViewParams);
        } else {
            vw_dialog_fl_center.setVisibility(8);
        }
        TextView vw_dialog_tv_ok = (TextView)dialog.findViewById(R.id.vw_dialog_tv_ok);
        if (!TextUtils.isEmpty((CharSequence)this.builder.positiveMsg)) {
            vw_dialog_tv_ok.setText(this.builder.positiveMsg);
        }
        vw_dialog_tv_ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BlurDialog.this.builder.positiveClick != null) {
                    BlurDialog.this.builder.positiveClick.onClick();
                }
            }
        });
        TextView vw_dialog_tv_cancel = (TextView)dialog.findViewById(R.id.vw_dialog_tv_cancel);
        if (!TextUtils.isEmpty((CharSequence)this.builder.negativeMsg)) {
            vw_dialog_tv_cancel.setText(this.builder.negativeMsg);
        }
        vw_dialog_tv_cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BlurDialog.this.builder.negativeClick != null) {
                    BlurDialog.this.builder.negativeClick.onClick();
                }
            }
        });
        float radius = BlurDialogHelper.getRadius(dialog.getContext(), this.builder.radius);
        RoundRectBlurView bv = (RoundRectBlurView)dialog.findViewById(R.id.bv);
        bv.setRadius(radius);
        vw_dialog_tv_ok = (TextView)dialog.findViewById(R.id.vw_dialog_tv_ok);
        BlurDialogHelper.setBackGroundDrawable(dialog.getContext(), (View)vw_dialog_tv_ok, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, 0.0f, 0.0f});
        vw_dialog_tv_cancel = (TextView)dialog.findViewById(R.id.vw_dialog_tv_cancel);
        BlurDialogHelper.setBackGroundDrawable(dialog.getContext(), (View)vw_dialog_tv_cancel, new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, radius, radius});
        this.centerStyle(dialog);
    }

    private void confirmSingleStyle(Dialog dialog) {
        this.confirmSingleStyle(dialog, this.mWindowPaddingStart, this.mWindowPaddingEnd);
    }

    private void confirmSingleStyle(Dialog dialog, int paddingStart, int paddingEnd) {
        dialog.setContentView(R.layout.vw_dialog_option_single);
        TextView vw_dialog_tv_msg = (TextView)dialog.findViewById(R.id.vw_dialog_tv_msg);
        vw_dialog_tv_msg.setText(this.builder.message);
        FrameLayout vw_dialog_fl_center = (FrameLayout)dialog.findViewById(R.id.vw_dialog_fl_center);
        if (this.builder.centerView != null && this.builder.centerViewParams != null) {
            vw_dialog_fl_center.setVisibility(0);
            vw_dialog_fl_center.addView(this.builder.centerView, (ViewGroup.LayoutParams)this.builder.centerViewParams);
        } else {
            vw_dialog_fl_center.setVisibility(8);
        }
        TextView vw_dialog_tv_ok = (TextView)dialog.findViewById(R.id.vw_dialog_tv_ok);
        if (!TextUtils.isEmpty((CharSequence)this.builder.positiveMsg)) {
            vw_dialog_tv_ok.setText(this.builder.positiveMsg);
        }
        vw_dialog_tv_ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BlurDialog.this.builder.positiveClick != null) {
                    BlurDialog.this.builder.positiveClick.onClick();
                }
            }
        });
        float radius = BlurDialogHelper.getRadius(dialog.getContext(), this.builder.radius);
        RoundRectBlurView bv = (RoundRectBlurView)dialog.findViewById(R.id.bv);
        bv.setRadius(radius);
        vw_dialog_tv_ok = (TextView)dialog.findViewById(R.id.vw_dialog_tv_ok);
        BlurDialogHelper.setBackGroundDrawable(dialog.getContext(), (View)vw_dialog_tv_ok, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, radius, radius});
        this.centerStyle(dialog, paddingStart, paddingEnd);
    }

    private void confirmNoneStyle(Dialog dialog) {
        this.confirmNoneStyle(dialog, this.mWindowPaddingStart, this.mWindowPaddingEnd);
    }

    private void confirmNoneStyle(Dialog dialog, int paddingStart, int paddingEnd) {
        dialog.setContentView(R.layout.vw_dialog_option_none);
        TextView vw_dialog_tv_msg = (TextView)dialog.findViewById(R.id.vw_dialog_tv_msg);
        vw_dialog_tv_msg.setText(this.builder.message);
        FrameLayout vw_dialog_fl_center = (FrameLayout)dialog.findViewById(R.id.vw_dialog_fl_center);
        if (this.builder.centerView != null && this.builder.centerViewParams != null) {
            vw_dialog_fl_center.setVisibility(0);
            vw_dialog_fl_center.addView(this.builder.centerView, (ViewGroup.LayoutParams)this.builder.centerViewParams);
        } else {
            vw_dialog_fl_center.setVisibility(8);
        }
        float radius = BlurDialogHelper.getRadius(dialog.getContext(), this.builder.radius);
        RoundRectBlurView bv = (RoundRectBlurView)dialog.findViewById(R.id.bv);
        bv.setRadius(radius);
        this.centerStyle(dialog, paddingStart, paddingEnd);
    }

    private void deleteStyle(Dialog dialog) {
        this.confirmDoubleStyle(dialog);
        TextView vw_dialog_tv_ok = (TextView)dialog.findViewById(R.id.vw_dialog_tv_ok);
        vw_dialog_tv_ok.setText((CharSequence)dialog.getContext().getResources().getString(R.string.vw_dialog_delete));
        vw_dialog_tv_ok.setTextColor(dialog.getContext().getResources().getColor(R.color.vw_dialog_red));
    }

    private void waitStyle(Dialog dialog, Builder builder) {
        builder.centerView(new IndeterminateProgressView(dialog.getContext()), new FrameLayout.LayoutParams((int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)dialog.getContext().getResources().getDisplayMetrics()), (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)dialog.getContext().getResources().getDisplayMetrics())));
        this.confirmNoneStyle(dialog, 120, 120);
    }

    private void progressStyle(Dialog dialog, Builder builder) {
        DeterminateProgressView view = new DeterminateProgressView(dialog.getContext());
        builder.centerView(view, new FrameLayout.LayoutParams((int)TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)dialog.getContext().getResources().getDisplayMetrics()), (int)TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)dialog.getContext().getResources().getDisplayMetrics())));
        this.confirmSingleStyle(dialog);
    }

    private void selectSingleStyle(Dialog dialog) {
        dialog.setContentView(R.layout.vw_dialog_select_single);
        TextView vw_dialog_tv_cancel = (TextView)dialog.findViewById(R.id.vw_dialog_tv_cancel);
        if (!TextUtils.isEmpty((CharSequence)this.builder.singleListCancelMsg)) {
            vw_dialog_tv_cancel.setText(this.builder.singleListCancelMsg);
        }
        vw_dialog_tv_cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BlurDialog.this.builder.negativeClick != null) {
                    BlurDialog.this.builder.negativeClick.onClick();
                }
            }
        });
        float radius = BlurDialogHelper.getRadius(dialog.getContext(), this.builder.radius);
        RoundRectBlurView bv1 = (RoundRectBlurView)dialog.findViewById(R.id.bv1);
        bv1.setRadius(radius);
        RoundRectBlurView bv2 = (RoundRectBlurView)dialog.findViewById(R.id.bv2);
        bv2.setRadius(radius);
        vw_dialog_tv_cancel = (TextView)dialog.findViewById(R.id.vw_dialog_tv_cancel);
        BlurDialogHelper.setBackGroundDrawable(dialog.getContext(), (View)vw_dialog_tv_cancel, new float[]{radius, radius, radius, radius, radius, radius, radius, radius});
        RecyclerView rv_content = (RecyclerView)dialog.findViewById(R.id.rv_content);
        rv_content.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(dialog.getContext()));
        rv_content.setAdapter((RecyclerView.Adapter)new SingleSelectAdapter(this.builder.singleList, radius, this.builder.itemClick));
        this.bottomStyle(dialog);
    }

    private void centerStyle(Dialog dialog) {
        this.centerStyle(dialog, this.mWindowPaddingStart, this.mWindowPaddingEnd);
    }

    private void centerStyle(Dialog dialog, int paddingStart, int paddingEnd) {
        Window window = dialog.getWindow();
        if (window == null) {
            return;
        }
        window.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)"#00000000")));
        window.setWindowAnimations(R.style.vw_dialog_anim_center);
        window.setGravity(17);
        window.getDecorView().setPadding((int)TypedValue.applyDimension((int)1, (float)paddingStart, (DisplayMetrics)dialog.getContext().getResources().getDisplayMetrics()), 0, (int)TypedValue.applyDimension((int)1, (float)paddingEnd, (DisplayMetrics)dialog.getContext().getResources().getDisplayMetrics()), 0);
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.width = -1;
        lp.height = -2;
        window.setAttributes(lp);
    }

    private void bottomStyle(Dialog dialog) {
        Window window = dialog.getWindow();
        if (window == null) {
            return;
        }
        window.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)"#00000000")));
        window.setWindowAnimations(R.style.vw_dialog_anim_bottom);
        window.setGravity(80);
        window.getDecorView().setPadding((int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)dialog.getContext().getResources().getDisplayMetrics()), 0, (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)dialog.getContext().getResources().getDisplayMetrics()), (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)dialog.getContext().getResources().getDisplayMetrics()));
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.width = -1;
        lp.height = -2;
        window.setAttributes(lp);
    }

    public void show() {
        if (this.mDialog != null) {
            this.mDialog.show();
        }
    }

    public void dismiss() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    public boolean isShowing() {
        if (this.mDialog != null) {
            return this.mDialog.isShowing();
        }
        return false;
    }

    public void setBuilder(Builder builder) {
        this.builder = builder;
        this.createDialog(builder.ctx);
    }

    public void setProgress(float percent) {
        if (this.mProgressAnimator != null && this.mProgressAnimator.isRunning()) {
            return;
        }
        if (percent - this.preProgress < 10.0f) {
            return;
        }
        if (this.builder.centerView != null && this.builder.centerView instanceof DeterminateProgressView && this.mDialog.isShowing() && this.preProgress < 100.0f) {
            this.curProgress = percent > 100.0f ? 100.0f : percent;
            this.mProgressAnimator = ObjectAnimator.ofFloat((Object)((Object)((DeterminateProgressView)this.builder.centerView)), (String)"progress", (float[])new float[]{this.preProgress, this.curProgress});
            this.mProgressAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    BlurDialog.this.preProgress = BlurDialog.this.curProgress;
                    if (BlurDialog.this.curProgress == 100.0f) {
                        BlurDialog.this.mDialog.dismiss();
                        BlurDialog.this.builder.onProgressFinishedListener.onProgressFinished();
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mProgressAnimator.start();
        }
    }

    public static interface OnProgressFinishedListener {
        public void onProgressFinished();
    }

    public static class Builder {
        private Context ctx;
        private boolean isCancelable;
        private boolean isOutsideCancelable;
        private int type = 0;
        private float radius = -1.0f;
        private CharSequence message;
        private CharSequence positiveMsg;
        private CharSequence negativeMsg;
        private List<CharSequence> singleList;
        private CharSequence singleListCancelMsg;
        private View centerView;
        private FrameLayout.LayoutParams centerViewParams;
        private OnPositiveClick positiveClick;
        private OnNegativeClick negativeClick;
        private OnItemClick itemClick;
        private DialogInterface.OnDismissListener dismissListener;
        private OnProgressFinishedListener onProgressFinishedListener;

        public Builder type(int type) {
            this.type = type;
            return this;
        }

        public Builder isCancelable(boolean cancelable) {
            this.isCancelable = cancelable;
            return this;
        }

        public Builder isOutsideCancelable(boolean cancelable) {
            this.isOutsideCancelable = cancelable;
            return this;
        }

        public Builder radius(float radius) {
            this.radius = radius;
            return this;
        }

        public Builder message(CharSequence msg) {
            this.message = msg;
            return this;
        }

        public Builder singleList(List<CharSequence> singleList) {
            this.singleList = singleList;
            return this;
        }

        public Builder singleListCancelMsg(CharSequence singleListCancelMsg) {
            this.singleListCancelMsg = singleListCancelMsg;
            return this;
        }

        public Builder centerView(View view, FrameLayout.LayoutParams params) {
            this.centerView = view;
            this.centerViewParams = params;
            return this;
        }

        public Builder positiveMsg(CharSequence positiveMsg) {
            this.positiveMsg = positiveMsg;
            return this;
        }

        public Builder negativeMsg(CharSequence negativeMsg) {
            this.negativeMsg = negativeMsg;
            return this;
        }

        public Builder positiveClick(OnPositiveClick positiveClick) {
            this.positiveClick = positiveClick;
            return this;
        }

        public Builder negativeClick(OnNegativeClick negativeClick) {
            this.negativeClick = negativeClick;
            return this;
        }

        public Builder itemClick(OnItemClick itemClick) {
            this.itemClick = itemClick;
            return this;
        }

        public Builder dismissListener(DialogInterface.OnDismissListener dismissListener) {
            this.dismissListener = dismissListener;
            return this;
        }

        public Builder onProgressFinishedListener(OnProgressFinishedListener onProgressFinishedListener) {
            this.onProgressFinishedListener = onProgressFinishedListener;
            return this;
        }

        public BlurDialog build(Context ctx) {
            this.ctx = ctx;
            BlurDialog helper = new BlurDialog(this);
            return helper.createDialog(ctx);
        }

        public Builder createBuilder(Context ctx) {
            this.ctx = ctx;
            return this;
        }
    }
}

