/*
 * Decompiled with CFR 0.152.
 */
package com.vincent.blurdialog.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

public class DeterminateProgressView
extends View {
    private static final float STEP = 3.6f;
    private int mViewHeight;
    private int mViewWidth;
    private int mCenterX;
    private int mCenterY;
    private float mStrokeWidth = 2.0f;
    private Paint mBasicPaint;
    private Paint mBasicCirclePaint;
    private RectF rectF;
    private PorterDuffXfermode xfermode;
    private float progress = 0.0f;

    public DeterminateProgressView(Context context) {
        super(context);
    }

    public DeterminateProgressView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public DeterminateProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public DeterminateProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mViewWidth = w;
        this.mViewHeight = h;
        this.mCenterX = this.mViewWidth / 2;
        this.mCenterY = this.mViewHeight / 2;
        this.init();
    }

    private void init() {
        this.mBasicPaint = new Paint();
        this.mBasicPaint.setAntiAlias(true);
        this.mBasicPaint.setDither(true);
        this.mBasicPaint.setFilterBitmap(true);
        this.mBasicPaint.setColor(Color.parseColor((String)"#FF47494D"));
        this.mBasicCirclePaint = new Paint();
        this.mBasicCirclePaint.setAntiAlias(true);
        this.mBasicCirclePaint.setDither(true);
        this.mBasicCirclePaint.setFilterBitmap(true);
        this.mBasicCirclePaint.setColor(Color.parseColor((String)"#FF47494D"));
        this.mBasicCirclePaint.setStyle(Paint.Style.STROKE);
        this.mBasicCirclePaint.setStrokeWidth(this.mStrokeWidth);
        this.rectF = new RectF(this.mStrokeWidth * 3.0f - 1.0f, this.mStrokeWidth * 3.0f - 1.0f, (float)this.mViewWidth - this.mStrokeWidth * 3.0f + 1.0f, (float)this.mViewHeight - this.mStrokeWidth * 3.0f + 1.0f);
        this.xfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int saved = canvas.saveLayer(null, null, 31);
        canvas.drawCircle((float)this.mCenterX, (float)this.mCenterY, (float)this.mCenterX - this.mStrokeWidth, this.mBasicCirclePaint);
        canvas.drawCircle((float)this.mCenterX, (float)this.mCenterY, (float)this.mCenterX - this.mStrokeWidth * 3.0f, this.mBasicPaint);
        this.mBasicPaint.setXfermode((Xfermode)this.xfermode);
        canvas.drawArc(this.rectF, -90.0f, this.progress * 3.6f, true, this.mBasicPaint);
        this.mBasicPaint.setXfermode(null);
        canvas.restoreToCount(saved);
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
        this.invalidate();
    }
}

