/*
 * Decompiled with CFR 0.152.
 */
package com.vimeo.android.deeplink;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;

public class VimeoDeeplink {
    private static final int VERSION_CODE_DEBUG = 0;
    private static final int VERSION_CODE_DEEP_LINK_CATEGORY = 48;
    private static final int VERSION_CODE_DEEP_LINK_USER = 49;
    private static final int VERSION_CODE_DEEP_LINK_VIDEO = 48;
    private static final int VERSION_CODE_DEEP_LINK_CATEGORIES = 74;
    private static final int VERSION_CODE_DEEP_LINK_CHANNELS = 74;
    private static final int VERSION_CODE_DEEP_LINK_EXPLORE = 74;
    private static final int VERSION_CODE_DEEP_LINK_FEED = 74;
    private static final int VERSION_CODE_DEEP_LINK_ME = 74;
    private static final int VERSION_CODE_DEEP_LINK_OFFLINE = 470;
    private static final int VERSION_CODE_DEEP_LINK_ONDEMAND = 470;
    private static final int VERSION_CODE_DEEP_LINK_PLAYLISTS = 74;
    private static final int VERSION_CODE_DEEP_LINK_PURCHASES = 470;
    private static final int VERSION_CODE_DEEP_LINK_UPLOAD = 74;
    private static final int VERSION_CODE_DEEP_LINK_URL = 234;
    private static final int VERSION_CODE_DEEP_LINK_WATCHLATER = 470;
    private static final String VIMEO_BASE_URL_HOST = "vimeo.com";
    private static final String VIMEO_BASE_URI = "vimeo://app.vimeo.com";
    private static final String VIMEO_APP_PACKAGE = "com.vimeo.android.videoapp";
    private static final String PLAY_STORE_URI = "market://details?id=com.vimeo.android.videoapp";
    private static final String PLAY_STORE_WEB_URL = "http://play.google.com/store/apps/details?id=com.vimeo.android.videoapp";
    private static final String CATEGORIES = "/categories";
    private static final String EXPLORE = "/explore";
    private static final String FEED = "/feed";
    private static final String ME = "/me";
    private static final String OFFLINE = "/offline";
    private static final String PLAYLISTS = "/playlists";
    private static final String PURCHASES = "/purchases";
    private static final String UPLOAD = "/upload";
    private static final String WATCH_LATER = "/watchlater";
    public static final String VIMEO_VIDEO_URI_PREFIX = "/videos/";
    public static final String VIMEO_USER_URI_PREFIX = "/users/";
    public static final String VIMEO_CATEGORY_URI_PREFIX = "/categories/";
    public static final String VIMEO_CHANNEL_URI_PREFIX = "/channels/";
    public static final String VIMEO_ONDEMAND_URI_PREFIX = "/ondemand/";

    public static boolean isVimeoAppInstalled(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            packageManager.getPackageInfo(VIMEO_APP_PACKAGE, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static boolean viewVimeoAppInAppStore(Context context) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)PLAY_STORE_URI));
        if (!VimeoDeeplink.startActivity(context, intent)) {
            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)PLAY_STORE_WEB_URL));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return true;
    }

    public static boolean openVimeoApp(Context context) {
        if (VimeoDeeplink.isVimeoAppInstalled(context)) {
            Intent LaunchIntent = context.getPackageManager().getLaunchIntentForPackage(VIMEO_APP_PACKAGE);
            context.startActivity(LaunchIntent);
            return true;
        }
        return false;
    }

    public static boolean canHandleVideoDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 48 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showVideoWithUri(Context context, String videoUriPath) {
        if (videoUriPath.startsWith(VIMEO_VIDEO_URI_PREFIX) && VimeoDeeplink.canHandleVideoDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)(VIMEO_BASE_URI + videoUriPath)));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleCategoryDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 48 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showCategoryWithUri(Context context, String categoryUriPath) {
        if (categoryUriPath.startsWith(VIMEO_CATEGORY_URI_PREFIX) && VimeoDeeplink.canHandleCategoryDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)(VIMEO_BASE_URI + categoryUriPath)));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleChannelDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showChannelWithUri(Context context, String channelUriPath) {
        if (channelUriPath.startsWith(VIMEO_CHANNEL_URI_PREFIX) && VimeoDeeplink.canHandleChannelDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)(VIMEO_BASE_URI + channelUriPath)));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleUserDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 49 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showUserWithUri(Context context, String userUriPath) {
        if (userUriPath.startsWith(VIMEO_USER_URI_PREFIX) && VimeoDeeplink.canHandleUserDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)(VIMEO_BASE_URI + userUriPath)));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleOnDemandDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 470 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showOnDemandTitleWithUri(Context context, String ondemandUriPath) {
        if (ondemandUriPath.startsWith(VIMEO_ONDEMAND_URI_PREFIX) && VimeoDeeplink.canHandleOnDemandDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)(VIMEO_BASE_URI + ondemandUriPath)));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean showCategories(Context context) {
        if (VimeoDeeplink.canHandleCategoiesDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/categories"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleCategoiesDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showExplore(Context context) {
        if (VimeoDeeplink.canHandleExploreDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/explore"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleExploreDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showFeed(Context context) {
        if (VimeoDeeplink.canHandleFeedDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/feed"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleFeedDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showMyProfile(Context context) {
        if (VimeoDeeplink.canHandleMeDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/me"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleMeDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showOffline(Context context) {
        if (VimeoDeeplink.canHandleOfflineDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/offline"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleOfflineDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 470 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showPlaylists(Context context) {
        if (VimeoDeeplink.canHandlePlaylistDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/playlists"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandlePlaylistDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showPurchases(Context context) {
        if (VimeoDeeplink.canHandlePlaylistDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/purchases"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandlePurchaseDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 470 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showUpload(Context context) {
        if (VimeoDeeplink.canHandleUploadDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/upload"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleUploadDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showWatchLater(Context context) {
        if (VimeoDeeplink.canHandleOfflineDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/watchlater"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleWatchLaterDeeplink(Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 470 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean openUrl(Context context, String url) {
        if (VimeoDeeplink.canHandleUrl(context, url)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleUrl(Context context, String url) {
        return (VimeoDeeplink.vimeoAppVersion(context) >= 234 || VimeoDeeplink.vimeoAppVersion(context) == 0) && url.toLowerCase().contains(VIMEO_BASE_URL_HOST);
    }

    private static int vimeoAppVersion(Context context) {
        if (VimeoDeeplink.isVimeoAppInstalled(context)) {
            PackageManager packageManager = context.getPackageManager();
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(VIMEO_APP_PACKAGE, 1);
                return packageInfo.versionCode;
            }
            catch (PackageManager.NameNotFoundException e) {
                return 0;
            }
        }
        return 0;
    }

    private static boolean startActivity(Context context, Intent intent) {
        if (intent != null && intent.resolveActivity(context.getPackageManager()) != null) {
            intent.addFlags(0x10008000);
            context.startActivity(intent);
            return true;
        }
        return false;
    }
}

