/*
 * Decompiled with CFR 0.152.
 */
package com.vimdream.htool.zip;

import com.vimdream.htool.string.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static void compress(String srcFilePath, String destFilePath, String baseDir) {
        File src = new File(srcFilePath);
        if (!src.exists()) {
            throw new RuntimeException(srcFilePath + "\u4e0d\u5b58\u5728");
        }
        try {
            ZipUtil.compress(srcFilePath, (OutputStream)new FileOutputStream(destFilePath), baseDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void compress(String srcFilePath, OutputStream out, String baseDir) {
        File src = new File(srcFilePath);
        if (!src.exists()) {
            throw new RuntimeException(srcFilePath + "\u4e0d\u5b58\u5728");
        }
        try {
            ZipOutputStream zos = new ZipOutputStream(out);
            if (StringUtil.isNotBlank(baseDir)) {
                if (src.isDirectory()) {
                    File[] files;
                    for (File file : files = src.listFiles()) {
                        ZipUtil.compress(file, zos, baseDir + File.separator);
                    }
                } else {
                    ZipUtil.compress(src, zos, baseDir + File.separator);
                }
            } else {
                ZipUtil.compress(src, zos, "");
            }
            zos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void compress(List<File> files, String destFilePath, String baseDir) {
        try {
            ZipUtil.compress(files, (OutputStream)new FileOutputStream(destFilePath), baseDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void compress(List<File> files, OutputStream out, String baseDir) {
        try {
            ZipOutputStream zos = new ZipOutputStream(out);
            baseDir = StringUtil.isNotBlank(baseDir) ? baseDir : "";
            for (File file : files) {
                ZipUtil.compress(file, zos, baseDir + File.separator);
            }
            zos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void compress(File src, ZipOutputStream zos, String baseDir) {
        if (!src.exists()) {
            return;
        }
        if (src.isFile()) {
            ZipUtil.compressFile(src, zos, baseDir);
        } else if (src.isDirectory()) {
            ZipUtil.compressDir(src, zos, baseDir);
        }
    }

    private static void compressFile(File file, ZipOutputStream zos, String baseDir) {
        if (!file.exists()) {
            return;
        }
        try {
            int count;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry entry = new ZipEntry(baseDir + file.getName());
            zos.putNextEntry(entry);
            byte[] buf = new byte[1024];
            while ((count = bis.read(buf)) != -1) {
                zos.write(buf, 0, count);
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void compressDir(File dir, ZipOutputStream zos, String baseDir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files.length == 0) {
            try {
                zos.putNextEntry(new ZipEntry(baseDir + dir.getName() + File.separator));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (File file : files) {
            ZipUtil.compress(file, zos, baseDir + dir.getName() + File.separator);
        }
    }
}

