/*
 * Decompiled with CFR 0.152.
 */
package com.vimdream.htool.time;

import java.util.ArrayList;
import java.util.List;

public class Timer {
    private long start;
    private long lastStart;
    private List<Number> points;

    public Timer() {
        this.lastStart = this.start = System.currentTimeMillis();
        this.points = new ArrayList<Number>();
    }

    public void cut(Unit unit, boolean compareToStart) {
        long lastStart = System.currentTimeMillis();
        this.points.add(this.formatUnit(lastStart - (compareToStart ? this.start : this.lastStart), unit));
        this.lastStart = lastStart;
    }

    public Number interval(Unit unit, boolean compareToStart) {
        long lastStart = System.currentTimeMillis();
        Number interval = this.formatUnit(lastStart - (compareToStart ? this.start : this.lastStart), unit);
        this.lastStart = lastStart;
        return interval;
    }

    public Number formatUnit(long time, Unit unit) {
        switch (unit) {
            case MILLISECOND: {
                return time;
            }
            case SECOND: {
                return (double)time / 1000.0;
            }
        }
        return 0;
    }

    public List<Number> getPoints() {
        return this.points;
    }

    public static enum Unit {
        MILLISECOND,
        SECOND;

    }
}

