/*
 * Decompiled with CFR 0.152.
 */
package com.vimdream.htool.string;

public class StringUtil {
    public static <T> T convert(String str, Class<T> clazz) {
        if (StringUtil.isBlank(str) || clazz == null) {
            return null;
        }
        if (String.class.equals(clazz)) {
            return (T)str;
        }
        try {
            if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
                return (T)Integer.valueOf(str);
            }
            if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
                return (T)Byte.valueOf(str);
            }
            if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
                return (T)Long.valueOf(str);
            }
            if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
                return (T)Double.valueOf(str);
            }
            if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
                return (T)Float.valueOf(str);
            }
            if (Character.class.equals(clazz) || Character.TYPE.equals(clazz)) {
                return (T)new Character(str.charAt(0));
            }
            if (Short.class.equals(clazz) || Short.TYPE.equals(clazz)) {
                return (T)Short.valueOf(str);
            }
            if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
                return (T)Boolean.valueOf(str);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362\u4e3a" + clazz.getName() + "\u5931\u8d25");
        }
        return null;
    }

    public static boolean isBlank(CharSequence s) {
        if (s != null && s.length() > 0) {
            for (int i = s.length() - 1; i >= 0; --i) {
                if (s.charAt(i) == ' ') continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence s) {
        return !StringUtil.isBlank(s);
    }

    public static boolean isNotEmpty(CharSequence s) {
        return s != null && s.length() > 0;
    }

    public static boolean isEmpty(CharSequence s) {
        return !StringUtil.isNotEmpty(s);
    }

    public static String format(String template, Object ... args) {
        return String.format(template, args);
    }
}

