/*
 * Decompiled with CFR 0.152.
 */
package com.vimdream.htool.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    public static final ObjectMapper mapper = new ObjectMapper();

    public static String serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == String.class) {
            return (String)obj;
        }
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("json\u5e8f\u5217\u5316\u51fa\u9519\uff1a" + obj, e);
        }
    }

    public static <T> T parse(String json, Class<T> tClass) {
        try {
            return (T)mapper.readValue(json, tClass);
        }
        catch (IOException e) {
            throw new RuntimeException("json\u89e3\u6790\u51fa\u9519\uff1a" + json, e);
        }
    }

    public static <E> List<E> parseList(String json, Class<E> eClass) {
        try {
            return (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, eClass));
        }
        catch (IOException e) {
            throw new RuntimeException("json\u89e3\u6790\u51fa\u9519\uff1a" + json, e);
        }
    }

    public static <K, V> Map<K, V> parseMap(String json, Class<K> kClass, Class<V> vClass) {
        try {
            return (Map)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructMapType(Map.class, kClass, vClass));
        }
        catch (IOException e) {
            throw new RuntimeException("json\u89e3\u6790\u51fa\u9519\uff1a" + json, e);
        }
    }

    public static <T> T nativeRead(String json, TypeReference<T> type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new RuntimeException("json\u89e3\u6790\u51fa\u9519\uff1a" + json, e);
        }
    }
}

