/*
 * Decompiled with CFR 0.152.
 */
package com.vimdream.htool.json;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.vimdream.htool.object.ObjectUtil;
import com.vimdream.htool.string.StringUtil;
import java.util.Arrays;
import java.util.Optional;

public class JSON {
    private String json;
    private JSONObject object;
    private JSONArray array;
    private int rootType = 0;
    public static final int JSON_STRING = 1;
    public static final int JSON_OBJECT = 2;
    public static final int JSON_ARRAY = 3;
    public static final String ARRAY_PREFIX = "[";
    public static final String ARRAY_SUFFIX = "]";
    public static final char PATH_SEPARATOR = '.';
    public static final String PATH_SPLIT_REGEX = "\\.";

    public JSON(String json) {
        this.json = json;
        this.rootType = 1;
    }

    public JSON(JSONObject object) {
        this.object = object;
        this.rootType = 2;
    }

    public JSON(JSONArray array) {
        this.array = array;
        this.rootType = 3;
    }

    public Object get(String path) {
        try {
            return this.access(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getOrDefault(String path, Object defaultVal) {
        return Optional.ofNullable(this.get(path)).orElse(defaultVal);
    }

    public <T> T get(String path, Class<T> clazz) {
        return ObjectUtil.convert(this.get(path), clazz);
    }

    public <T> T getOrDefault(String path, Object defaultVal, Class<T> clazz) {
        return ObjectUtil.convert(this.getOrDefault(path, defaultVal), clazz);
    }

    public Object access(String path) {
        String correctPath = this.checkPath(path);
        String[] nodes = this.parsePath(correctPath);
        int len = nodes.length;
        this.ensureRoot();
        int curType = this.rootType;
        JSONObject curObj = this.object;
        JSONArray curArr = this.array;
        int nextType = -1;
        String cur = "";
        String nextKey = "";
        block8: for (int i = 0; i < len - 1; ++i) {
            cur = nodes[i];
            nextType = this.getNodePathType(cur);
            nextKey = nextType == 2 ? cur : this.getArrayPathKey(cur);
            switch (curType) {
                case 2: {
                    if (curObj.containsKey((Object)nextKey)) {
                        if (nextType == 3) {
                            JSONArray array = this.getJSONArray(curObj, nextKey);
                            int index = this.getArrayPathIndex(cur);
                            if (i + 1 >= len) continue block8;
                            if (index >= array.size()) {
                                throw new IllegalArgumentException("\u6570\u7ec4\u4e0b\u6807\u8d8a\u754c " + cur);
                            }
                            int type = this.getNodePathType(nodes[i + 1]);
                            if (type == 3 && nodes[i + 1].indexOf(ARRAY_PREFIX) == 0) {
                                curArr = array.getJSONArray(index);
                                curType = 3;
                                continue block8;
                            }
                            curObj = array.getJSONObject(index);
                            curType = 2;
                            continue block8;
                        }
                        curObj = this.getJSONObject(curObj, nextKey);
                        continue block8;
                    }
                    throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684key " + nextKey);
                }
                case 3: {
                    int index = this.getArrayPathIndex(cur);
                    if (index < curArr.size()) {
                        if (nextType == 3) {
                            if (i + 1 >= len) continue block8;
                            int type = this.getNodePathType(nodes[i + 1]);
                            if (type == 3 && nodes[i + 1].indexOf(ARRAY_PREFIX) == 0) {
                                curArr = curArr.getJSONArray(index);
                                curType = 3;
                                continue block8;
                            }
                            curObj = curArr.getJSONObject(index);
                            curType = 2;
                            continue block8;
                        }
                        curObj = curArr.getJSONObject(index);
                        curType = 2;
                        continue block8;
                    }
                    throw new IllegalArgumentException("\u6570\u7ec4\u4e0b\u6807\u8d8a\u754c " + cur);
                }
                default: {
                    throw new IllegalArgumentException("\u672a\u77e5\u7684\u7c7b\u578b");
                }
            }
        }
        String lastNode = nodes[len - 1];
        int lastNodeType = this.getNodePathType(lastNode);
        String lastNodeKey = lastNodeType == 2 ? lastNode : this.getArrayPathKey(lastNode);
        switch (lastNodeType) {
            case 2: {
                return curObj.get((Object)lastNodeKey);
            }
            case 3: {
                int index = this.getArrayPathIndex(lastNode);
                if (curType == 2) {
                    curArr = this.getJSONArray(curObj, lastNodeKey);
                }
                if (index < curArr.size()) {
                    return curArr.get(index);
                }
                throw new IllegalArgumentException("\u6570\u7ec4\u4e0b\u6807\u8d8a\u754c " + lastNode);
            }
        }
        throw new IllegalArgumentException("\u672a\u77e5\u7684\u7c7b\u578b");
    }

    private JSONArray getJSONArray(JSONObject obj, Object key) {
        Object o = obj.get(key);
        if (o == null) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684key " + key);
        }
        if (!(o instanceof JSONArray)) {
            throw new IllegalArgumentException(key + "\u5bf9\u5e94\u7684\u503c\u4e0d\u662fJSONArray\u7c7b\u578b");
        }
        return (JSONArray)o;
    }

    private JSONObject getJSONObject(JSONObject obj, Object key) {
        Object o = obj.get(key);
        if (o == null) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684key " + key);
        }
        if (!(o instanceof JSONObject)) {
            throw new IllegalArgumentException(key + "\u5bf9\u5e94\u7684\u503c\u4e0d\u662fJSONObject\u7c7b\u578b");
        }
        return (JSONObject)o;
    }

    private int getNodePathType(String node) {
        if (node.contains(ARRAY_PREFIX)) {
            return 3;
        }
        return 2;
    }

    private String getArrayPathKey(String node) {
        return node.substring(0, node.indexOf(ARRAY_PREFIX));
    }

    private int getArrayPathIndex(String node) {
        String index = node.substring(node.indexOf(ARRAY_PREFIX) + 1, node.length() - 1);
        return StringUtil.isBlank(index) ? 0 : Integer.parseInt(index);
    }

    private String checkPath(String path) {
        if (StringUtil.isBlank(path)) {
            throw new IllegalArgumentException("\u8bbf\u95ee\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder correctPath = new StringBuilder();
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            if (c == ' ') continue;
            if (c == '.' && correctPath.charAt(correctPath.length() - 1) == '.') {
                throw new IllegalArgumentException("\u65e0\u6548\u7684path " + path);
            }
            correctPath.append(c);
        }
        return correctPath.toString();
    }

    private String[] parsePath(String path) {
        String[] targets = path.split(PATH_SPLIT_REGEX);
        int len = targets.length;
        if (len < 1) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684path " + path);
        }
        String[] nodes = this.correctNodes(targets);
        if (nodes == null) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684path " + path);
        }
        return nodes;
    }

    private String[] correctNodes(String[] targets) {
        int left = 0;
        int right = targets.length - 1;
        while (StringUtil.isBlank(targets[left])) {
            ++left;
        }
        if (left > right) {
            return null;
        }
        while (StringUtil.isBlank(targets[right])) {
            --right;
        }
        if (right - left < 2) {
            return Arrays.copyOfRange(targets, left, right + 1);
        }
        for (int i = left + 1; i < right; ++i) {
            if (!StringUtil.isBlank(targets[left])) continue;
            return null;
        }
        return Arrays.copyOfRange(targets, left, right + 1);
    }

    private void ensureRoot() {
        switch (this.rootType) {
            case 1: {
                Object object = JSONObject.parse((String)this.json);
                if (object instanceof JSONObject) {
                    this.object = (JSONObject)object;
                    this.rootType = 2;
                    break;
                }
                if (object instanceof JSONArray) {
                    this.array = (JSONArray)object;
                    this.rootType = 3;
                    break;
                }
                throw new IllegalArgumentException("\u65e0\u6548\u7684JSON\u5b57\u7b26\u4e32");
            }
            case 2: {
                if (this.object != null) break;
                throw new IllegalArgumentException("JSONObject\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case 3: {
                if (this.array != null) break;
                throw new IllegalArgumentException("JSONArray\u4e0d\u80fd\u4e3a\u7a7a");
            }
            default: {
                throw new IllegalArgumentException("\u672a\u53d1\u73b0JSON\u5bf9\u8c61");
            }
        }
    }
}

