/*
 * Decompiled with CFR 0.152.
 */
package com.vimdream.htool.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    public static void transfer(File from, File to) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(from));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(to));
            IOUtil.transfer(bis, bos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void transfer(InputStream from, OutputStream to) {
        try (InputStream is = from;
             OutputStream os = to;){
            byte[] bytes = new byte[1024];
            int len = 0;
            while ((len = is.read(bytes)) > 0) {
                os.write(bytes, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void store(String text, String filePath, boolean append) {
        File file = new File(filePath);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("\u786e\u4fdd " + filePath + "\u4e3a\u6587\u4ef6\u8def\u5f84");
        }
        IOUtil.store(text, file, append);
    }

    public static void store(String text, File file, boolean append) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file, append));){
            writer.write(text);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

