/*
 * Decompiled with CFR 0.152.
 */
package com.vimdream.htool.io;

import com.vimdream.htool.io.IOUtil;
import com.vimdream.htool.string.StringUtil;
import java.io.File;

public class FileUtil {
    public static void rename(String path, String newName) {
        FileUtil.rename(new File(path), newName);
    }

    public static void rename(File file, String newName) {
        file.renameTo(new File(file.getParentFile(), newName));
    }

    public static void copy(String sourcePath, String targetPath, boolean isForce) {
        if (StringUtil.isNotBlank(sourcePath) && StringUtil.isNotBlank(targetPath)) {
            FileUtil.copy(new File(sourcePath), new File(targetPath), isForce);
        }
    }

    public static void copy(File source, File target, boolean isForce) {
        if (source != null && target != null && source.exists() && target.isDirectory()) {
            if (source.isFile()) {
                FileUtil.copyFile(source, target, isForce);
            } else {
                FileUtil.copyDir(source, target, isForce);
            }
        }
    }

    private static void copyFile(File source, File target, boolean isForce) {
        File newFile = new File(target, source.getName());
        if (!isForce && newFile.exists()) {
            throw new IllegalArgumentException(newFile.getAbsolutePath() + "\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728");
        }
        IOUtil.transfer(source, newFile);
    }

    private static void copyDir(File source, File target, boolean isForce) {
        File[] files;
        File parentDir = new File(target, source.getName());
        parentDir.mkdirs();
        for (File file : files = source.listFiles()) {
            if (file.isFile()) {
                FileUtil.copyFile(file, parentDir, isForce);
                continue;
            }
            FileUtil.copyDir(file, parentDir, isForce);
        }
    }

    public static void del(String path) {
        if (StringUtil.isNotBlank(path)) {
            FileUtil.del(new File(path));
        }
    }

    public static void del(File file) {
        if (file != null && file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else {
                FileUtil.delDir(file);
            }
        }
    }

    private static void delDir(File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                file.delete();
                continue;
            }
            FileUtil.delDir(file);
        }
        dir.delete();
    }

    public String getHashPath(String name) {
        String hashPath = null;
        int code = name.hashCode();
        String hex = Integer.toHexString(code);
        int len = hex.length();
        if (len < 2) {
            return "00" + File.separator + "00";
        }
        hashPath = hex.substring(0, 2) + File.separator;
        hashPath = len >= 3 ? hashPath + hex.substring(len - 2) : hashPath + "00";
        return hashPath;
    }
}

