/*
 * Decompiled with CFR 0.152.
 */
package com.vikingsen.inject.worker;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import com.vikingsen.inject.worker.WorkerInjectFactory;
import java.util.Map;
import javax.inject.Inject;

public class WorkerFactory
extends androidx.work.WorkerFactory {
    private static final String TAG = "WI-WorkerFactory";
    private final Map<String, WorkerInjectFactory> factories;

    @Inject
    public WorkerFactory(@NonNull Map<String, WorkerInjectFactory> factories) {
        if (factories == null) {
            throw new NullPointerException("factories == null");
        }
        this.factories = factories;
    }

    @Nullable
    public ListenableWorker createWorker(@NonNull Context appContext, @NonNull String workerClassName, @NonNull WorkerParameters workerParameters) {
        WorkerInjectFactory factory = this.factories.get(workerClassName);
        if (factory != null) {
            try {
                return factory.create(appContext, workerParameters);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

