/*
 * Decompiled with CFR 0.152.
 */
package com.viae.maven.sonar.utils;

import com.viae.maven.sonar.exceptions.SonarQualityException;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonUtil {
    private static final JSONParser jsonParser = new JSONParser();

    private JsonUtil() {
    }

    public static final String getIdOnMainLevel(String jsonString) throws SonarQualityException {
        JSONObject json;
        String id = null;
        if (StringUtils.isNotBlank((CharSequence)jsonString) && (json = JsonUtil.parse(jsonString)).containsKey((Object)"id")) {
            id = json.get((Object)"id").toString();
        }
        return id;
    }

    public static final String getOnMainLevel(String jsonString, String fieldName) throws SonarQualityException {
        JSONObject json;
        String id = null;
        if (StringUtils.isNotBlank((CharSequence)jsonString) && (json = JsonUtil.parse(jsonString)).containsKey((Object)fieldName)) {
            id = json.get((Object)fieldName).toString();
        }
        return id;
    }

    private static JSONObject parse(String json) throws SonarQualityException {
        try {
            Object jsonObject = jsonParser.parse(json);
            return jsonObject instanceof JSONObject ? (JSONObject)jsonObject : (JSONObject)((JSONArray)jsonObject).get(0);
        }
        catch (ParseException e) {
            throw new SonarQualityException(String.format("could not parse json \n%s\nCause: %s", json, e.toString()));
        }
    }

    public static JSONArray parseArray(String json) throws SonarQualityException {
        try {
            JSONArray result = new JSONArray();
            if (StringUtils.isNotBlank((CharSequence)json)) {
                Object jsonObject = jsonParser.parse(json);
                if (jsonObject instanceof JSONArray) {
                    result = (JSONArray)jsonObject;
                } else {
                    result.add(jsonObject);
                }
            }
            return result;
        }
        catch (ParseException e) {
            throw new SonarQualityException(String.format("could not parse json \n%s\nCause: %s", json, e.toString()));
        }
    }
}

