/*
 * Decompiled with CFR 0.152.
 */
package com.viae.maven.sonar.services;

import com.viae.maven.sonar.exceptions.GitException;
import com.viae.maven.sonar.services.GitService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.logging.Log;

public class GitServiceImpl
implements GitService {
    private final Log log;

    public GitServiceImpl(Log log) {
        Validate.notNull((Object)log, (String)"log can't be null", (Object[])new Object[0]);
        this.log = log;
    }

    @Override
    public String getBranchName(Runtime runtime) throws GitException {
        try {
            String tempName;
            String sonarBranchName = "";
            Process p = runtime.exec("git rev-parse --abbrev-ref HEAD");
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            if (reader != null && StringUtils.isNotEmpty((CharSequence)(tempName = reader.readLine()))) {
                sonarBranchName = tempName.trim();
            }
            this.log.info((CharSequence)String.format("set sonar.branch [%s]", sonarBranchName));
            return sonarBranchName;
        }
        catch (IOException | InterruptedException e) {
            throw new GitException(e);
        }
    }
}

