/*
 * Decompiled with CFR 0.152.
 */
package com.viae.maven.sonar.mojos;

import com.viae.maven.sonar.services.GitService;
import com.viae.maven.sonar.services.GitServiceImpl;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="set-git-branch", aggregator=true)
public class SonarMavenSetGitBranchMojo
extends AbstractMojo {
    private final GitService gitService = new GitServiceImpl(this.getLog());
    @Component
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)String.format("%s start execution of '%s'", "VIAE log:", "set-git-branch"));
        try {
            String resultingBranchName;
            String existingBranchValue = this.project.getProperties().getProperty("sonar.branch");
            this.getLog().info((CharSequence)String.format("%s existing %s: '%s'", "VIAE log:", "sonar.branch", existingBranchValue));
            if (StringUtils.isBlank((CharSequence)existingBranchValue)) {
                String sonarBranchName = this.gitService.getBranchName(Runtime.getRuntime());
                this.getLog().info((CharSequence)String.format("%s set property '%s' to '%s'", "VIAE log:", "sonar.branch", sonarBranchName));
                resultingBranchName = sonarBranchName;
            } else {
                resultingBranchName = existingBranchValue;
            }
            this.project.getProperties().setProperty("sonar.branch", Optional.ofNullable(resultingBranchName).orElse("").replace("/", "-"));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("%s %s", "VIAE log:", e.getLocalizedMessage()));
            throw new MojoFailureException(String.format("%s %s\ncause:\n%s", "VIAE log:", e.getLocalizedMessage(), ExceptionUtils.getStackTrace((Throwable)e)), (Throwable)e);
        }
    }
}

