/*
 * Decompiled with CFR 0.152.
 */
package com.viae.maven.sonar.mojos;

import com.viae.maven.sonar.services.SonarQualityGateService;
import com.viae.maven.sonar.services.SonarQualityGateServiceImpl;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonar.wsclient.SonarClient;

@Mojo(name="link-project-to-qualitygate", aggregator=true)
public class SonarMavenLinkProjectToQualityGateMojo
extends AbstractMojo {
    @Parameter(property="sonar.host.url", required=true)
    protected String sonarServer;
    @Parameter(property="sonar.projectKey")
    protected String sonarKey;
    @Parameter(property="sonar.login", required=true)
    protected String sonarUser;
    @Parameter(property="sonar.password", required=true)
    protected String sonarPassword;
    @Parameter(property="sonar.qualitygate", required=true)
    protected String qualityGateName;
    @Parameter(property="sonar.branch")
    protected String branchName;
    @Component
    protected MavenProject project;
    private final SonarQualityGateService qualityGateService = new SonarQualityGateServiceImpl(this.getLog());

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)String.format("%s start execution of '%s'", "VIAE log:", "link-project-to-qualitygate"));
        this.getLog().info((CharSequence)String.format("%s use sonar server '%s' and log in with user '%s'", "VIAE log:", this.sonarServer, this.sonarUser));
        try {
            SonarClient client = SonarClient.builder().url(this.sonarServer).login(this.sonarUser).password(this.sonarPassword).build();
            String projectKey = this.qualityGateService.composeSonarProjectKey(this.project, this.sonarKey, this.branchName);
            this.getLog().info((CharSequence)String.format("%s property '%s': %s", "VIAE log:", "sonar.login", this.sonarUser));
            int passwordLength = this.sonarPassword != null ? this.sonarPassword.length() : 0;
            this.getLog().info((CharSequence)String.format("%s property length '%s': %s", "VIAE log:", "sonar.password", passwordLength));
            this.getLog().info((CharSequence)String.format("%s property '%s': %s", "VIAE log:", "sonar.projectKey", this.sonarKey));
            this.getLog().info((CharSequence)String.format("%s property '%s': %s", "VIAE log:", "sonar.branch", this.branchName));
            this.getLog().info((CharSequence)String.format("%s computed project key: %s", "VIAE log:", projectKey));
            this.getLog().info((CharSequence)String.format("%s property '%s': %s", "VIAE log:", "sonar.qualitygate", this.qualityGateName));
            this.getLog().info((CharSequence)String.format("%s property '%s': %s", "VIAE log:", "sonar.projectKey", projectKey));
            this.getLog().info((CharSequence)String.format("%s link project '%s' to quality gate %s", "VIAE log:", projectKey, this.qualityGateName));
            this.qualityGateService.linkQualityGateToProject(client, projectKey, this.qualityGateName);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("%s %s", "VIAE log:", e.getLocalizedMessage()));
            throw new MojoFailureException(String.format("%s %s\ncause:\n%s", "VIAE log:", e.getLocalizedMessage(), ExceptionUtils.getStackTrace((Throwable)e)), (Throwable)e);
        }
    }
}

