/*
 * Decompiled with CFR 0.152.
 */
package com.viae.maven.sonar.mojos;

import com.viae.maven.sonar.services.SonarQualityGateService;
import com.viae.maven.sonar.services.SonarQualityGateServiceImpl;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonar.wsclient.SonarClient;

@Mojo(name="set-sonar-execution-start", aggregator=true)
public class SonarMavenInitSonarExecutionStartMojo
extends AbstractMojo {
    private final SonarQualityGateService qualityGateService = new SonarQualityGateServiceImpl(this.getLog());
    @Parameter(property="sonar.host.url", required=true)
    protected String sonarServer;
    @Parameter(property="sonar.projectKey")
    protected String sonarKey;
    @Parameter(property="sonar.login", required=true)
    protected String sonarUser;
    @Parameter(property="sonar.password", required=true)
    protected String sonarPassword;
    @Parameter(property="sonar.branch")
    protected String branchName;
    @Parameter(property="sonar.qualitygate", required=true)
    protected String qualityGateName;
    @Component
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)String.format("%s start execution of '%s'", "VIAE log:", "set-sonar-execution-start"));
        this.getLog().info((CharSequence)String.format("%s use sonar server '%s' and log in with user '%s'", "VIAE log:", this.sonarServer, this.sonarUser));
        String existingExecutionStart = this.project.getProperties().getProperty("sonar.execution.start");
        this.getLog().info((CharSequence)String.format("%s existing %s: '%s'", "VIAE log:", "sonar.execution.start", existingExecutionStart));
        if (StringUtils.isBlank((CharSequence)existingExecutionStart)) {
            try {
                SonarClient client = SonarClient.builder().url(this.sonarServer).login(this.sonarUser).password(this.sonarPassword).build();
                LocalDateTime lastRunTimeStamp = this.qualityGateService.getLastRunTimeStamp(client, this.qualityGateService.composeSonarProjectKey(this.project, this.sonarKey, this.branchName), this.qualityGateName);
                this.getLog().info((CharSequence)String.format("%s last run timestamp (i.e. from sonar): '%s'", "VIAE log:", lastRunTimeStamp));
                LocalDateTime executionStart = lastRunTimeStamp != null ? lastRunTimeStamp : LocalDateTime.now();
                String executionStartValue = String.valueOf(DateTimeFormatter.ISO_DATE_TIME.format(executionStart));
                this.getLog().info((CharSequence)String.format("%s set property '%s' to '%s'", "VIAE log:", "sonar.execution.start", executionStartValue));
                this.project.getProperties().setProperty("sonar.execution.start", executionStartValue);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)String.format("%s %s", "VIAE log:", e.getLocalizedMessage()));
                throw new MojoFailureException(String.format("%s %s\ncause:\n%s", "VIAE log:", e.getLocalizedMessage(), ExceptionUtils.getStackTrace((Throwable)e)), (Throwable)e);
            }
        }
    }
}

