/*
 * Decompiled with CFR 0.152.
 */
package com.viae.maven.sonar.mojos;

import com.viae.maven.sonar.services.SonarQualityGateService;
import com.viae.maven.sonar.services.SonarQualityGateServiceImpl;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonar.wsclient.SonarClient;

@Mojo(name="validate-qualitygate", aggregator=true)
public class SonarMavenBuildBreakerMojo
extends AbstractMojo {
    public static final int FIVE_MINUTES_IN_SECONDS = 500;
    private final SonarQualityGateService qualityGateService = new SonarQualityGateServiceImpl(this.getLog());
    @Parameter(property="sonar.host.url", required=true)
    protected String sonarServer;
    @Parameter(property="sonar.projectKey")
    protected String sonarKey;
    @Parameter(property="sonar.branch")
    protected String branchName;
    @Parameter(property="sonar.login", required=true)
    protected String sonarUser;
    @Parameter(property="sonar.password", required=true)
    protected String sonarPassword;
    @Parameter(property="sonar.execution.start")
    protected String sonarExecutionStart;
    @Parameter(property="sonar.qualitygate", required=true)
    protected String qualityGateName;
    @Component
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)String.format("%s start execution of '%s'", "VIAE log:", "validate-qualitygate"));
        this.getLog().info((CharSequence)String.format("%s use sonar server '%s' and log in with user '%s'", "VIAE log:", this.sonarServer, this.sonarUser));
        try {
            SonarClient client = SonarClient.builder().url(this.sonarServer).login(this.sonarUser).password(this.sonarPassword).build();
            this.getLog().info((CharSequence)String.format("validate quality gate for %s[%s] and branch [%s]", "sonar.projectKey", this.sonarKey, this.branchName));
            String computedProjectKey = this.qualityGateService.composeSonarProjectKey(this.project, this.sonarKey, this.branchName);
            this.getLog().info((CharSequence)String.format("%s property '%s': %s", "VIAE log:", "sonar.projectKey", this.sonarKey));
            this.getLog().info((CharSequence)String.format("%s property '%s': %s", "VIAE log:", "sonar.branch", this.branchName));
            this.getLog().info((CharSequence)String.format("%s computed project key: %s", "VIAE log:", computedProjectKey));
            if (!StringUtils.isBlank((CharSequence)this.sonarExecutionStart)) {
                LocalDateTime executionStart = LocalDateTime.parse(this.sonarExecutionStart, DateTimeFormatter.ISO_DATE_TIME);
                this.qualityGateService.validateQualityGate(client, computedProjectKey, this.qualityGateName, executionStart, 500);
            } else {
                this.qualityGateService.validateQualityGate(client, computedProjectKey, this.qualityGateName);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("%s %s", "VIAE log:", e.getLocalizedMessage()));
            throw new MojoFailureException(String.format("%s %s\ncause:\n%s", "VIAE log:", e.getLocalizedMessage(), ExceptionUtils.getStackTrace((Throwable)e)), (Throwable)e);
        }
    }
}

