/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.net;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Charsets;
import com.google.protobuf.ByteString;
import com.vesoft.nebula.driver.graph.ErrorCode;
import com.vesoft.nebula.driver.graph.data.HostAddress;
import com.vesoft.nebula.driver.graph.exception.AuthFailedException;
import com.vesoft.nebula.driver.graph.exception.IOErrorException;
import com.vesoft.nebula.driver.graph.net.AuthResult;
import com.vesoft.nebula.driver.graph.net.Connection;
import com.vesoft.nebula.driver.graph.net.NebulaClient;
import com.vesoft.nebula.driver.graph.utils.TlsUtil;
import com.vesoft.nebula.proto.common.ClientInfo;
import com.vesoft.nebula.proto.common.Common;
import com.vesoft.nebula.proto.graph.AuthRequest;
import com.vesoft.nebula.proto.graph.AuthResponse;
import com.vesoft.nebula.proto.graph.ExecuteRequest;
import com.vesoft.nebula.proto.graph.ExecuteResponse;
import com.vesoft.nebula.proto.graph.GraphServiceGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcConnection
extends Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcConnection.class);
    private ManagedChannel channel;
    private GraphServiceGrpc.GraphServiceBlockingStub stub;
    private long connectTimeout = 0L;
    private long requestTimeout = 0L;
    private final Charset charset = Charsets.UTF_8;

    @Override
    public void open(HostAddress address, NebulaClient.Builder builder) throws IOErrorException {
        this.serverAddr = address;
        this.connectTimeout = builder.connectTimeoutMills;
        this.requestTimeout = builder.requestTimeoutMills;
        if (builder.enableTls) {
            try {
                NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)address.getHost(), (int)address.getPort()).useTransportSecurity().sslContext(TlsUtil.getSslContext(builder.disableVerifyServerCert, builder.tlsCa, builder.tlsCert, builder.tlsKey)).maxInboundMessageSize(Integer.MAX_VALUE);
                this.channel = channelBuilder.build();
            }
            catch (SSLException e) {
                throw new IOErrorException(6, e.getMessage());
            }
        } else {
            this.channel = NettyChannelBuilder.forAddress((String)address.getHost(), (int)address.getPort()).usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE).build();
        }
        this.stub = GraphServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    @Override
    public void close() {
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdown();
        }
        this.stub = null;
    }

    @Override
    public boolean ping(long sessionID, long timeoutMs) throws IOErrorException {
        ExecuteResponse response = this.execute(sessionID, "RETURN 1", timeoutMs);
        return ErrorCode.SUCCESSFUL_COMPLETION.code.equals(response.getStatus().getCode().toString(this.charset));
    }

    public AuthResult authenticate(String user, Map<String, Object> authOptions) throws AuthFailedException, IOErrorException {
        try {
            ClientInfo clientInfo = ClientInfo.newBuilder().setLang(ClientInfo.Language.JAVA).setProtocolVersion((ByteString)Common.getDescriptor().getOptions().getExtension(Common.protocolVersion)).setVersion(ByteString.copyFrom((String)"5.2-SNAPSHOT", (Charset)this.charset)).build();
            ByteString userString = user == null ? ByteString.copyFrom((String)"", (Charset)this.charset) : ByteString.copyFrom((String)user, (Charset)this.charset);
            String authInfoString = JSON.toJSONString(authOptions);
            AuthRequest authReq = AuthRequest.newBuilder().setUsername(userString).setAuthInfo(ByteString.copyFrom((String)authInfoString, (Charset)this.charset)).setClientInfo(clientInfo).build();
            AuthResponse resp = ((GraphServiceGrpc.GraphServiceBlockingStub)this.stub.withDeadlineAfter(this.connectTimeout, TimeUnit.MILLISECONDS)).authenticate(authReq);
            String code = resp.getStatus().getCode().toString(this.charset);
            if (!ErrorCode.SUCCESSFUL_COMPLETION.code.equals(code)) {
                this.close();
                throw new AuthFailedException(resp.getStatus().getMessage().toString(this.charset));
            }
            return new AuthResult(resp.getSessionId(), resp.getVersion().toString(this.charset));
        }
        catch (Exception e) {
            this.close();
            if (e instanceof StatusRuntimeException && ((StatusRuntimeException)e).getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED) {
                throw new AuthFailedException(String.format("authenticate to %s timeout after %dms", this.serverAddr.toString(), this.connectTimeout));
            }
            if (e instanceof StatusRuntimeException) {
                throw new IOErrorException(0, e.getMessage());
            }
            throw e;
        }
    }

    public ExecuteResponse execute(long sessionID, String stmt, long timeout) throws IOErrorException {
        if (stmt == null) {
            throw new NullPointerException("statement is null.");
        }
        try {
            ExecuteRequest request = ExecuteRequest.newBuilder().setSessionId(sessionID).setStmt(ByteString.copyFrom((String)stmt, (Charset)this.charset)).build();
            return ((GraphServiceGrpc.GraphServiceBlockingStub)this.stub.withDeadlineAfter(timeout, TimeUnit.MILLISECONDS)).execute(request);
        }
        catch (Exception e) {
            if (e instanceof StatusRuntimeException && ((StatusRuntimeException)e).getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED) {
                throw new IOErrorException(4, String.format("request to %s timeout after %dms", this.serverAddr.toString(), timeout));
            }
            throw e;
        }
    }

    public ExecuteResponse execute(long sessionID, String stmt) throws IOErrorException {
        return this.execute(sessionID, stmt, this.requestTimeout);
    }
}

